/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BootLockTest
extends BaseJDBCTestCase {
    private static final String dbName = "BootLockTestDB";
    private static final String dbDir = "system" + File.separator + "BootLockTestDB";
    public static String minionCompleteFileName = dbDir + File.separator + "minionComplete";
    private static final String dbLockFile = dbDir + File.separator + "db.lck";
    private static final String dbExLockFile = dbDir + File.separator + "dbex.lck";
    private static final String servicePropertiesFileName = dbDir + File.separator + "service.properties";
    private static String[] cmd = new String[]{"org.apache.derbyTesting.functionTests.tests.store.BootLockMinion", "BootLockTestDB"};
    private static final String DATA_MULTIPLE_JBMS_ON_DB = "XSDB6";
    private static final String DATA_MULTIPLE_JBMS_FORCE_LOCK = "XSDB8";
    public static final int MINION_WAIT_MAX_MILLIS = 600000;

    public BootLockTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BootLockTest");
        baseTestSuite.addTest(BootLockTest.decorateTest());
        return baseTestSuite;
    }

    private static Test decorateTest() {
        Object object = new BaseTestSuite(BootLockTest.class);
        if (JDBC.vmSupportsJSR169() && !BootLockTest.isJ9Platform()) {
            Properties properties = new Properties();
            properties.setProperty("derby.database.forceDatabaseLock", "true");
            object = new SystemPropertyTestSetup((Test)object, properties, true);
        }
        object = TestConfiguration.singleUseDatabaseDecorator((Test)object, dbName);
        object = SecurityManagerSetup.noSecurityManager((Test)object);
        return object;
    }

    public void testBootLock() throws Exception {
        Object object;
        Process process = null;
        process = BootLockTest.execJavaCmd(cmd);
        this.waitForMinionBoot(process, 600000);
        try {
            object = this.getConnection();
            BootLockTest.fail((String)"Dual boot not detected: check BootLockMinion.log");
        }
        catch (SQLException sQLException) {
            if (JDBC.vmSupportsJSR169() && !BootLockTest.isJ9Platform()) {
                BootLockTest.assertSQLState("Dual boot not detected: check BootLockMinion.log", DATA_MULTIPLE_JBMS_FORCE_LOCK, sQLException);
            } else {
                BootLockTest.assertSQLState("Dual boot not detected: check BootLockMinion.log", DATA_MULTIPLE_JBMS_ON_DB, sQLException);
            }
        }
        finally {
            if (process != null) {
                process.destroy();
                process.waitFor();
            }
        }
        object = new File("system", "BootLockMinion.log");
        BootLockTest.assertTrue((boolean)((File)object).delete());
        if (JDBC.vmSupportsJSR169()) {
            File file = new File(dbLockFile);
            File file2 = new File(dbExLockFile);
            file.delete();
            file2.delete();
        }
    }

    private void waitForMinionBoot(Process process, int n) throws InterruptedException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(dbLockFile);
        File file2 = new File(servicePropertiesFileName);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string = null;
        File file3 = new File(minionCompleteFileName);
        do {
            if (file3.exists()) {
                return;
            }
            n -= 1000;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                BootLockTest.fail((String)interruptedException.getMessage());
            }
        } while (n > 0);
        stringBuffer.append("Minion did not start or boot db in 600 seconds.\n");
        try {
            int n2 = process.exitValue();
            bl = true;
            stringBuffer.append("exitValue = " + n2);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = false;
        }
        if (bl) {
            stringBuffer.append("----Process exited. Minion's stderr:\n");
            do {
                try {
                    string = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    stringBuffer.append("could not read minion's stderr");
                }
                if (string == null) continue;
                stringBuffer.append(string);
            } while (string != null);
            stringBuffer.append("\n----Minion's stderr ended");
        }
        process.destroy();
        process.waitFor();
        BootLockTest.fail((String)stringBuffer.toString());
    }
}

