/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.compatibility.VersionCombinationConfigurator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.ServerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class _Suite
extends BaseJDBCTestCase {
    static final String INCLUDE_RELEASES = "derby.tests.compat.includeReleases";
    static final String EXCLUDE_RELEASES = "derby.tests.compat.excludeReleases";
    protected static VersionCombinationConfigurator configurator;

    private static int addVersionCombinations(BaseTestSuite baseTestSuite) {
        String string = _Suite.getSystemProperty(INCLUDE_RELEASES);
        String string2 = _Suite.getSystemProperty(EXCLUDE_RELEASES);
        List<DerbyVersion> list = _Suite.parseVersionList(string);
        List<DerbyVersion> list2 = _Suite.parseVersionList(string2);
        if (configurator == null) {
            configurator = VersionCombinationConfigurator.getInstanceDevMATS();
        }
        baseTestSuite.setName("Compatibility suite, " + configurator.getName());
        configurator.setIncludes(list);
        configurator.setExcludes(list2);
        return configurator.addTests(baseTestSuite);
    }

    private static List<DerbyVersion> parseVersionList(String string) {
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        String[] stringArray = string.split(",");
        ArrayList<DerbyVersion> arrayList = new ArrayList<DerbyVersion>(stringArray.length);
        for (String string2 : stringArray) {
            try {
                arrayList.add(DerbyVersion.parseVersionString(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _Suite.alarm("badly formatted version string: " + string2);
            }
        }
        return arrayList;
    }

    public _Suite(String string) {
        super(string);
        throw new IllegalStateException("invoke suite() instead");
    }

    public static Test suite() {
        if (JVMInfo.isModuleAware()) {
            return new BaseTestSuite("tests.compatibility disabled when using a module path");
        }
        if (_Suite.suffersFromDerby5889()) {
            String string = "tests.compatibility disabled on Windows with UNC paths, see DERBY-5889";
            _Suite.println(string);
            return new BaseTestSuite(string);
        }
        if (!TestConfiguration.loadingFromJars()) {
            return new BaseTestSuite("Compatibility tests skipped becasue they need to run from jars");
        }
        if (!Derby.hasClient() || !Derby.hasServer()) {
            return new BaseTestSuite("Compatibility tests skipped because client or server is missing");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        _Suite.addVersionCombinations(baseTestSuite);
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        return new SecurityManagerSetup((Test)new ServerSetup((Test)baseTestSuite, "localhost", testConfiguration.getPort()), VersionCombinationConfigurator.class.getName().replaceAll("\\.", "/") + ".policy", true);
    }

    public static boolean suffersFromDerby5889() {
        if (!_Suite.isWindowsPlatform()) {
            return false;
        }
        DerbyDistribution[] derbyDistributionArray = TestConfiguration.getReleaseRepository().getDistributions();
        for (int i = 0; i < derbyDistributionArray.length; ++i) {
            if (!derbyDistributionArray[i].getDerbyEngineJarPath().startsWith("\\\\")) continue;
            return true;
        }
        return false;
    }
}

