/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class resultsetJdbc20 {
    private static String[] testObjects = new String[]{"TABLE T"};

    public static void main(String[] args) {
        String[] columnNames = new String[]{"i", "s", "r", "d", "dt", "t", "ts", "c", "v", "dc"};
        System.out.println("Test resultsetJdbc20 starting");
        try {
            ij.getPropertyArg((String[])args);
            Connection con = ij.startJBMS();
            Statement stmt = con.createStatement();
            TestUtil.cleanUpTest(stmt, testObjects);
            stmt.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2))");
            stmt.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.07'),'eight','nine', 10.1)");
            ResultSet rs = stmt.executeQuery("select * from t");
            ResultSetMetaData met = rs.getMetaData();
            int colCount = met.getColumnCount();
            System.out.println("getColumnCount(): " + colCount);
            for (int i = 1; i <= colCount; ++i) {
                if (i == 2 && met.getColumnClassName(i).equals("java.lang.Short")) {
                    System.out.println("getColumnName(" + i + "): " + met.getColumnName(i));
                    System.out.println("FAIL: should be java.lang.Integer - but is java.lang.Short. see beetle 5775");
                    continue;
                }
                System.out.println("getColumnName(" + i + "): " + met.getColumnName(i));
                System.out.println("getColumnClassName(" + i + "): " + met.getColumnClassName(i));
            }
            rs.close();
            TestUtil.cleanUpTest(stmt, testObjects);
            stmt.close();
            con.close();
        }
        catch (SQLException e) {
            resultsetJdbc20.dumpSQLExceptions(e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception: " + e);
            e.printStackTrace();
        }
        System.out.println("Test resultsetJdbc20 finished");
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception");
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se);
            se = se.getNextException();
        }
    }
}

