/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealJoinResultSetStatistics;

public class RealNestedLoopJoinStatistics
extends RealJoinResultSetStatistics {
    public boolean oneRowRightSide;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;
    protected String nodeName;
    public String resultSetName;

    public RealNestedLoopJoinStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsSeenLeft, int rowsSeenRight, int rowsReturned, long restrictionTime, boolean oneRowRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, ResultSetStatistics leftResultSetStatistics, ResultSetStatistics rightResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, rowsSeenLeft, rowsSeenRight, rowsReturned, restrictionTime, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
        this.oneRowRightSide = oneRowRightSide;
        this.leftResultSetStatistics = leftResultSetStatistics;
        this.rightResultSetStatistics = rightResultSetStatistics;
        this.setNames();
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String header = "";
        if (this.userSuppliedOptimizerOverrides != null) {
            header = this.indent + MessageService.getTextMessage("43Y57.U", this.userSuppliedOptimizerOverrides);
            header = header + "\n";
        }
        return header + this.indent + this.resultSetName + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U", new Object[0]) + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U", new Object[0]) + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43X81.U", new Object[0]) + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U", new Object[0]) + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U", new Object[0]) + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.leftResultSetStatistics.getScanStatisticsText(tableName, depth) + this.rightResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.leftResultSetStatistics);
        children.addElement(this.rightResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    protected void setNames() {
        if (this.nodeName == null) {
            if (this.oneRowRightSide) {
                this.nodeName = MessageService.getTextMessage("43X84.U", new Object[0]);
                this.resultSetName = MessageService.getTextMessage("43X85.U", new Object[0]);
            } else {
                this.nodeName = MessageService.getTextMessage("43X86.U", new Object[0]);
                this.resultSetName = MessageService.getTextMessage("43X87.U", new Object[0]);
            }
        }
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.leftResultSetStatistics != null) {
            ++noChildren;
        }
        if (this.rightResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.leftResultSetStatistics != null) {
            this.leftResultSetStatistics.accept(visitor);
        }
        if (this.rightResultSetStatistics != null) {
            this.rightResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "NLJOIN";
    }

    @Override
    public String getRSXplainDetails() {
        String op_details = "(" + this.resultSetNumber + ")";
        if (this.oneRowRightSide) {
            op_details = op_details + ", EXISTS JOIN";
        }
        return op_details;
    }
}

