/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketchIterator;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.FloatsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;

public abstract class KllFloatsSketch
extends KllSketch
implements QuantilesFloatsAPI {
    private FloatsSketchSortedView floatsSV = null;
    static final int ITEM_BYTES = 4;

    KllFloatsSketch(KllSketch.SketchStructure sketchStructure) {
        super(KllSketch.SketchType.KLL_FLOATS_SKETCH, sketchStructure);
    }

    KllFloatsSketch(KllMemorySegmentValidate segVal) {
        super(segVal);
    }

    public static KllFloatsSketch newHeapInstance() {
        return KllFloatsSketch.newHeapInstance(200);
    }

    public static KllFloatsSketch newHeapInstance(int k) {
        return new KllHeapFloatsSketch(k, 8);
    }

    public static KllFloatsSketch newDirectInstance(MemorySegment dstSeg) {
        return KllFloatsSketch.newDirectInstance(200, dstSeg, null);
    }

    public static KllFloatsSketch newDirectInstance(int k, MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(dstSeg, "Parameter 'dstSeg' must not be null");
        return KllDirectFloatsSketch.newDirectUpdatableInstance(k, 8, dstSeg, mSegReq);
    }

    public static KllFloatsSketch heapify(MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        return KllHeapFloatsSketch.heapifyImpl(srcSeg);
    }

    public static KllFloatsSketch wrap(MemorySegment srcSeg) {
        return KllFloatsSketch.wrap(srcSeg, null);
    }

    public static KllFloatsSketch wrap(MemorySegment srcSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(srcSeg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
        return new KllDirectFloatsSketch(srcSeg, segVal, mSegReq);
    }

    @Override
    public double[] getCDF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.floatsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double[] getPMF(float[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.floatsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.floatsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public float[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        float[] quantiles = new float[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.floatsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public float getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public float getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.floatsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(float[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.floatsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesFloatsSketchIterator iterator() {
        return new KllFloatsSketchIterator(this.getFloatItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (this == other) {
            throw new SketchesArgumentException("A sketch cannot merge with itself. ");
        }
        KllFloatsSketch othFltSk = (KllFloatsSketch)other;
        if (othFltSk.isEmpty()) {
            return;
        }
        KllFloatsHelper.mergeFloatImpl(this, othFltSk);
        this.floatsSV = null;
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(Float.NaN);
        this.setMaxItem(Float.NaN);
        this.setFloatItemsArray(new float[k]);
        this.floatsSV = null;
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withLevels, boolean withLevelsAndItems) {
        KllFloatsSketch sketch = this;
        if (withLevelsAndItems && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            MemorySegment seg = this.getMemorySegment();
            assert (seg != null);
            sketch = KllFloatsSketch.heapify(this.getMemorySegment());
        }
        return KllHelper.toStringImpl(sketch, withLevels, withLevelsAndItems);
    }

    @Override
    public void update(float item) {
        if (Float.isNaN(item)) {
            return;
        }
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllFloatsSketch.updateFloat(this, item);
        this.floatsSV = null;
    }

    static void updateFloat(KllFloatsSketch fltSk, float item) {
        fltSk.updateMinMax(item);
        int freeSpace = fltSk.levelsArr[0];
        assert (freeSpace >= 0);
        if (freeSpace == 0) {
            KllFloatsHelper.compressWhileUpdatingSketch(fltSk);
            freeSpace = fltSk.levelsArr[0];
            assert (freeSpace > 0);
        }
        fltSk.incN(1);
        fltSk.setLevelZeroSorted(false);
        int nextPos = freeSpace - 1;
        fltSk.setLevelsArrayAt(0, nextPos);
        fltSk.setFloatItemsArrayAt(nextPos, item);
    }

    final void updateMinMax(float item) {
        if (this.isEmpty() || Float.isNaN(this.getMinItemInternal())) {
            this.setMinItem(item);
            this.setMaxItem(item);
        } else {
            this.setMinItem(Math.min(this.getMinItemInternal(), item));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), item));
        }
    }

    public void update(float item, long weight) {
        if (Float.isNaN(item)) {
            return;
        }
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (weight < 1L) {
            throw new SketchesArgumentException("Weight is less than one.");
        }
        if (weight == 1L) {
            KllFloatsSketch.updateFloat(this, item);
        } else if (weight < (long)this.levelsArr[0]) {
            for (int i = 0; i < (int)weight; ++i) {
                KllFloatsSketch.updateFloat(this, item);
            }
        } else {
            KllHeapFloatsSketch tmpSk = new KllHeapFloatsSketch(this.getK(), 8, item, weight);
            this.merge(tmpSk);
        }
        this.floatsSV = null;
    }

    public void update(float[] items, int offset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (length == 0) {
            return;
        }
        if (!KllFloatsSketch.hasNaN(items, offset, length)) {
            this.updateFloat(items, offset, length);
            this.floatsSV = null;
            return;
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            float v = items[i];
            if (Float.isNaN(v)) continue;
            KllFloatsSketch.updateFloat(this, v);
            this.floatsSV = null;
        }
    }

    private void updateFloat(float[] srcItems, int srcOffset, int length) {
        int numItemsToCopy;
        if (this.isEmpty() || Float.isNaN(this.getMinItemInternal())) {
            this.setMinItem(srcItems[srcOffset]);
            this.setMaxItem(srcItems[srcOffset]);
        }
        for (int count = 0; count < length; count += numItemsToCopy) {
            if (this.levelsArr[0] == 0) {
                KllFloatsHelper.compressWhileUpdatingSketch(this);
            }
            int spaceNeeded = length - count;
            int freeSpace = this.levelsArr[0];
            assert (freeSpace > 0);
            numItemsToCopy = Math.min(spaceNeeded, freeSpace);
            int dstOffset = freeSpace - numItemsToCopy;
            int localSrcOffset = srcOffset + count;
            this.setFloatItemsArrayAt(dstOffset, srcItems, localSrcOffset, numItemsToCopy);
            this.updateMinMax(srcItems, localSrcOffset, numItemsToCopy);
            this.incN(numItemsToCopy);
            this.setLevelsArrayAt(0, dstOffset);
        }
        this.setLevelZeroSorted(false);
    }

    private void updateMinMax(float[] srcItems, int srcOffset, int length) {
        int end = srcOffset + length;
        for (int i = srcOffset; i < end; ++i) {
            this.setMinItem(Math.min(this.getMinItemInternal(), srcItems[i]));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), srcItems[i]));
        }
    }

    private static boolean hasNaN(float[] items, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (!Float.isNaN(items[i])) continue;
            return true;
        }
        return false;
    }

    abstract float[] getFloatItemsArray();

    abstract float[] getFloatRetainedItemsArray();

    abstract float getFloatSingleItem();

    abstract float getMaxItemInternal();

    abstract void setMaxItem(float var1);

    abstract float getMinItemInternal();

    abstract void setMinItem(float var1);

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    int getMinMaxSizeBytes() {
        return 8;
    }

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getNumRetained() * 4;
    }

    @Override
    ArrayOfItemsSerDe<?> getSerDe() {
        return null;
    }

    @Override
    final byte[] getSingleItemByteArr() {
        byte[] bytes = new byte[4];
        ByteArrayUtil.putFloatLE(bytes, 0, this.getFloatSingleItem());
        return bytes;
    }

    @Override
    int getSingleItemSizeBytes() {
        return 4;
    }

    @Override
    abstract byte[] getTotalItemsByteArr();

    @Override
    int getTotalItemsNumBytes() {
        return this.levelsArr[this.getNumLevels()] * 4;
    }

    abstract void setFloatItemsArray(float[] var1);

    abstract void setFloatItemsArrayAt(int var1, float var2);

    abstract void setFloatItemsArrayAt(int var1, float[] var2, int var3, int var4);

    @Override
    public FloatsSketchSortedView getSortedView() {
        this.refreshSortedView();
        return this.floatsSV;
    }

    private final FloatsSketchSortedView refreshSortedView() {
        if (this.floatsSV == null) {
            CreateSortedView csv = new CreateSortedView(this);
            this.floatsSV = csv.getSV();
        }
        return this.floatsSV;
    }

    private static void blockyTandemMergeSort(float[] quantiles, long[] weights, int[] levels, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        float[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllFloatsSketch.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels);
    }

    private static void blockyTandemMergeSortRecursion(float[] quantilesSrc, long[] weightsSrc, float[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllFloatsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1);
        KllFloatsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2);
        KllFloatsSketch.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2);
    }

    private static void tandemMerge(float[] quantilesSrc, long[] weightsSrc, float[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (quantilesSrc[iSrc1] < quantilesSrc[iSrc2]) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    private final class CreateSortedView {
        float[] quantiles;
        long[] cumWeights;
        final /* synthetic */ KllFloatsSketch this$0;

        private CreateSortedView(KllFloatsSketch kllFloatsSketch) {
            KllFloatsSketch kllFloatsSketch2 = kllFloatsSketch;
            Objects.requireNonNull(kllFloatsSketch2);
            this.this$0 = kllFloatsSketch2;
        }

        FloatsSketchSortedView getSV() {
            if (this.this$0.isEmpty()) {
                throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
            }
            float[] srcQuantiles = this.this$0.getFloatItemsArray();
            int[] srcLevels = this.this$0.levelsArr;
            int srcNumLevels = this.this$0.getNumLevels();
            if (!this.this$0.isLevelZeroSorted()) {
                Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1]);
                if (!this.this$0.hasMemorySegment()) {
                    this.this$0.setLevelZeroSorted(true);
                }
            }
            int numQuantiles = this.this$0.getNumRetained();
            this.quantiles = new float[numQuantiles];
            this.cumWeights = new long[numQuantiles];
            this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
            return new FloatsSketchSortedView(this.quantiles, this.cumWeights, this.this$0);
        }

        private void populateFromSketch(float[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
            int[] myLevels = new int[srcNumLevels + 1];
            int offset = srcLevels[0];
            System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
            int srcLevel = 0;
            int dstLevel = 0;
            long weight = 1L;
            while (srcLevel < srcNumLevels) {
                int fromIndex = srcLevels[srcLevel] - offset;
                int toIndex = srcLevels[srcLevel + 1] - offset;
                if (fromIndex < toIndex) {
                    Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                    myLevels[dstLevel] = fromIndex;
                    myLevels[dstLevel + 1] = toIndex;
                    ++dstLevel;
                }
                ++srcLevel;
                weight *= 2L;
            }
            int numLevels = dstLevel;
            KllFloatsSketch.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels);
            KllHelper.convertToCumulative(this.cumWeights);
        }
    }
}

