/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.RelativeErrorTables;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectUnionTest {
    static final String LS = System.getProperty("line.separator");
    static final int[] nArr = new int[]{1, 3, 10, 30, 100, 300, 1000, 3000, 10000, 30000};
    static final String hdrFmt = "%6s%6s%6s%8s%5s%5s%5s%7s%6s%7s%6s%6s%3s%2s%2s%13s%12s";
    static final String hdr = String.format("%6s%6s%6s%8s%5s%5s%5s%7s%6s%7s%6s%6s%3s%2s%2s%13s%12s", "n1", "n2", "tot", "lgMaxK", "lgK1", "lgK2", "lgKR", "tgt1", "tgt2", "Mode1", "Mode2", "ModeR", "1", "2", "R", "Est", "Err%");

    @Test
    public void checkUnions() {
        int t1 = 2;
        int t2 = 2;
        int rt = 2;
        DirectUnionTest.println("TgtR: " + TgtHllType.values()[rt].toString());
        int lgK1 = 7;
        int lgK2 = 7;
        int lgMaxK = 7;
        int n1 = 7;
        int n2 = 7;
        DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
        n1 = 8;
        n2 = 7;
        DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
        n1 = 7;
        n2 = 8;
        DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
        n1 = 8;
        n2 = 8;
        DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
        n1 = 7;
        n2 = 14;
        DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
        DirectUnionTest.println("++END BASE GROUP++");
        int i = 0;
        for (i = 7; i <= 13; ++i) {
            lgK1 = i;
            lgK2 = i;
            lgMaxK = i;
            n2 = n1 = (1 << i - 3) * 3 / 4;
            DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 -= 2, n2 += 2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.println("--END MINOR GROUP--");
            lgK1 = i;
            lgK2 = i + 1;
            lgMaxK = i;
            n2 = n1 = (1 << i - 3) * 3 / 4;
            DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 -= 2, n2 += 2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.println("--END MINOR GROUP--");
            lgK1 = i + 1;
            lgK2 = i;
            lgMaxK = i;
            n2 = n1 = (1 << i - 3) * 3 / 4;
            DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 -= 2, n2 += 2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.println("--END MINOR GROUP--");
            lgK1 = i + 1;
            lgK2 = i + 1;
            lgMaxK = i;
            n2 = n1 = (1 << i - 3) * 3 / 4;
            DirectUnionTest.basicUnion(n1, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 -= 2, n2 += 2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.basicUnion(n1 += 2, n2, lgK1, lgK2, lgMaxK, t1, t2, rt);
            DirectUnionTest.println("++END MAJOR GROUP++");
        }
    }

    @Test
    public void check() {
        DirectUnionTest.basicUnion(8, 7, 7, 7, 7, 2, 2, 2);
    }

    private static void basicUnion(int n1, int n2, int lgK1, int lgK2, int lgMaxK, int t1, int t2, int rt) {
        long i;
        long v = 0L;
        int tot = n1 + n2;
        TgtHllType type1 = TgtHllType.values()[t1];
        String t1str = type1.toString();
        TgtHllType type2 = TgtHllType.values()[t2];
        String t2str = type2.toString();
        TgtHllType resultType = TgtHllType.values()[rt];
        HllSketch h1 = new HllSketch(lgK1, type1);
        HllSketch h2 = new HllSketch(lgK2, type2);
        int lgControlK = Math.min(Math.min(lgK1, lgK2), lgMaxK);
        HllSketch control = new HllSketch(lgControlK, resultType);
        String dataFmt = "%6d%6d%6d,%7d%5d%5d%5d,%6s%6s,%6s%6s%6s,%2s%2s%2s,%12f%12f%%";
        for (i = 0L; i < (long)n1; ++i) {
            h1.update(v + i);
            control.update(v + i);
        }
        v += (long)n1;
        for (i = 0L; i < (long)n2; ++i) {
            h2.update(v + i);
            control.update(v + i);
        }
        v += (long)n2;
        String h1SketchStr = "H1 SKETCH: \n" + h1.toString();
        String h2SketchStr = "H2 SKETCH: \n" + h2.toString();
        Union union = DirectUnionTest.newUnion(lgMaxK);
        union.update(h1);
        String uH1SketchStr = "Union after H1: \n" + union.getResult(resultType).toString();
        union.update(h2);
        HllSketch result = union.getResult(resultType);
        int lgKR = result.getLgConfigK();
        String uSketchStr = "Union after H2: \n" + result.toString();
        double uEst = result.getEstimate();
        double uUb = result.getUpperBound(2);
        double uLb = result.getLowerBound(2);
        double rerr = (uEst / (double)tot - 1.0) * 100.0;
        String mode1 = h1.getCurMode().toString();
        String mode2 = h2.getCurMode().toString();
        String modeR = result.getCurMode().toString();
        String cSketchStr = "CONTROL SKETCH: \n" + control.toString();
        double controlEst = control.getEstimate();
        double controlUb = control.getUpperBound(2);
        double controlLb = control.getLowerBound(2);
        String h1ooo = h1.isOutOfOrder() ? "T" : "F";
        String h2ooo = h2.isOutOfOrder() ? "T" : "F";
        String resultooo = result.isOutOfOrder() ? "T" : "F";
        String row = String.format(dataFmt, n1, n2, tot, lgMaxK, lgK1, lgK2, lgKR, t1str, t2str, mode1, mode2, modeR, h1ooo, h2ooo, resultooo, uEst, rerr);
        DirectUnionTest.println(h1SketchStr);
        DirectUnionTest.println(h2SketchStr);
        DirectUnionTest.println(uH1SketchStr);
        DirectUnionTest.println(uSketchStr);
        DirectUnionTest.println(cSketchStr);
        DirectUnionTest.println(hdr);
        DirectUnionTest.println(row);
        Assert.assertTrue((controlUb - controlEst >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((uUb - uEst >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((controlEst - controlLb >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((uEst - uLb >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void checkToFromUnion1() {
        for (int i = 0; i < 10; ++i) {
            int n = nArr[i];
            for (int lgK = 4; lgK <= 13; ++lgK) {
                DirectUnionTest.toFrom1(lgK, TgtHllType.HLL_4, n);
                DirectUnionTest.toFrom1(lgK, TgtHllType.HLL_6, n);
                DirectUnionTest.toFrom1(lgK, TgtHllType.HLL_8, n);
            }
            DirectUnionTest.println("=======");
        }
    }

    private static void toFrom1(int lgK, TgtHllType tgtHllType, int n) {
        Union srcU = DirectUnionTest.newUnion(lgK);
        HllSketch srcSk = new HllSketch(lgK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            srcSk.update((long)i);
        }
        DirectUnionTest.println("n: " + n + ", lgK: " + lgK + ", type: " + String.valueOf(tgtHllType));
        srcU.update(srcSk);
        byte[] byteArr = srcU.toCompactByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        Union dstU = Union.heapify((Memory)mem);
        Assert.assertEquals((double)dstU.getEstimate(), (double)srcU.getEstimate(), (double)0.0);
    }

    @Test
    public void checkToFromUnion2() {
        for (int i = 0; i < 10; ++i) {
            int n = nArr[i];
            for (int lgK = 4; lgK <= 13; ++lgK) {
                DirectUnionTest.toFrom2(lgK, TgtHllType.HLL_4, n);
                DirectUnionTest.toFrom2(lgK, TgtHllType.HLL_6, n);
                DirectUnionTest.toFrom2(lgK, TgtHllType.HLL_8, n);
            }
            DirectUnionTest.println("=======");
        }
    }

    private static void toFrom2(int lgK, TgtHllType tgtHllType, int n) {
        Union srcU = DirectUnionTest.newUnion(lgK);
        HllSketch srcSk = new HllSketch(lgK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            srcSk.update((long)i);
        }
        DirectUnionTest.println("n: " + n + ", lgK: " + lgK + ", type: " + String.valueOf(tgtHllType));
        srcU.update(srcSk);
        byte[] byteArr = srcU.toCompactByteArray();
        Union dstU = Union.heapify((byte[])byteArr);
        Assert.assertEquals((double)dstU.getEstimate(), (double)srcU.getEstimate(), (double)0.0);
    }

    @Test
    public void checkCompositeEst() {
        int i;
        Union u = DirectUnionTest.newUnion(12);
        Assert.assertEquals((double)u.getCompositeEstimate(), (double)0.0, (double)0.03);
        for (i = 1; i <= 15; ++i) {
            u.update((long)i);
        }
        Assert.assertEquals((double)u.getCompositeEstimate(), (double)15.0, (double)0.44999999999999996);
        for (i = 15; i <= 1000; ++i) {
            u.update((long)i);
        }
        Assert.assertEquals((double)u.getCompositeEstimate(), (double)1000.0, (double)30.0);
    }

    @Test
    public void checkMisc() {
        Union u2;
        try {
            u2 = DirectUnionTest.newUnion(3);
            Assert.fail();
        }
        catch (SketchesArgumentException u2) {
            // empty catch block
        }
        try {
            u2 = DirectUnionTest.newUnion(22);
            Assert.fail();
        }
        catch (SketchesArgumentException u3) {
            // empty catch block
        }
        u2 = DirectUnionTest.newUnion(7);
        HllSketch sk = u2.getResult();
        Assert.assertTrue((boolean)sk.isEmpty());
    }

    @Test
    public void checkHeapify() {
        Union u = DirectUnionTest.newUnion(16);
        for (int i = 0; i < 0x100000; ++i) {
            u.update((long)i);
        }
        double est1 = u.getEstimate();
        byte[] byteArray = u.toUpdatableByteArray();
        Union u2 = Union.heapify((byte[])byteArray);
        Assert.assertEquals((double)u2.getEstimate(), (double)est1, (double)0.0);
    }

    @Test
    public void checkUbLb() {
        int lgK = 4;
        int n = 0x100000;
        boolean oooFlag = false;
        DirectUnionTest.println("LgK=" + lgK + ", UB3, " + (DirectUnionTest.getBound(lgK, true, oooFlag, 3, n) / (double)n - 1.0));
        DirectUnionTest.println("LgK=" + lgK + ", UB2, " + (DirectUnionTest.getBound(lgK, true, oooFlag, 2, n) / (double)n - 1.0));
        DirectUnionTest.println("LgK=" + lgK + ", UB1, " + (DirectUnionTest.getBound(lgK, true, oooFlag, 1, n) / (double)n - 1.0));
        DirectUnionTest.println("LgK=" + lgK + ", LB1, " + (DirectUnionTest.getBound(lgK, false, oooFlag, 1, n) / (double)n - 1.0));
        DirectUnionTest.println("LgK=" + lgK + ", LB2, " + (DirectUnionTest.getBound(lgK, false, oooFlag, 2, n) / (double)n - 1.0));
        DirectUnionTest.println("LgK=" + lgK + ", LB3, " + (DirectUnionTest.getBound(lgK, false, oooFlag, 3, n) / (double)n - 1.0));
    }

    @Test
    public void checkEmptyCouponMisc() {
        int lgK = 8;
        Union union = DirectUnionTest.newUnion(lgK);
        for (int i = 0; i < 20; ++i) {
            union.update((long)i);
        }
        union.couponUpdate(0);
        Assert.assertEquals((double)union.getEstimate(), (double)20.0, (double)0.001);
        Assert.assertEquals((Object)union.getTgtHllType(), (Object)TgtHllType.HLL_8);
        Assert.assertTrue((boolean)union.isMemory());
        Assert.assertFalse((boolean)union.isOffHeap());
        int bytes = union.getUpdatableSerializationBytes();
        Assert.assertTrue((bytes <= Union.getMaxSerializationBytes((int)lgK) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)union.isCompact());
    }

    @Test
    public void checkUnionWithWrap() {
        int lgConfigK = 4;
        TgtHllType type = TgtHllType.HLL_4;
        int n = 2;
        HllSketch sk = new HllSketch(lgConfigK, type);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        double est = sk.getEstimate();
        byte[] skByteArr = sk.toCompactByteArray();
        HllSketch sk2 = HllSketch.wrap((Memory)Memory.wrap((byte[])skByteArr));
        Assert.assertEquals((double)sk2.getEstimate(), (double)est, (double)0.0);
        Union union = DirectUnionTest.newUnion(lgConfigK);
        union.update(HllSketch.wrap((Memory)Memory.wrap((byte[])skByteArr)));
        Assert.assertEquals((double)union.getEstimate(), (double)est, (double)0.0);
    }

    @Test
    public void checkUnionWithWrap2() {
        int lgConfigK = 10;
        int n = 128;
        HllSketch sk1 = new HllSketch(lgConfigK);
        for (int i = 0; i < n; ++i) {
            sk1.update((long)i);
        }
        double est1 = sk1.getEstimate();
        byte[] byteArr1 = sk1.toCompactByteArray();
        Union union = DirectUnionTest.newUnion(lgConfigK);
        union.update(HllSketch.wrap((Memory)Memory.wrap((byte[])byteArr1)));
        double est2 = union.getEstimate();
        Assert.assertEquals((double)est2, (double)est1);
    }

    @Test
    public void checkWritableWrap() {
        int lgConfigK = 10;
        int n = 128;
        Union union = DirectUnionTest.newUnion(lgConfigK);
        for (int i = 0; i < n; ++i) {
            union.update((long)i);
        }
        double est = union.getEstimate();
        Union union2 = Union.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])union.toUpdatableByteArray()));
        double est2 = union2.getEstimate();
        Assert.assertEquals((double)est2, (double)est, (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkWritableWrapThrows() {
        int lgConfigK = 10;
        int n = 128;
        HllSketch sk = new HllSketch(lgConfigK, TgtHllType.HLL_6);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i);
        }
        Union.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])sk.toUpdatableByteArray()));
    }

    private static Union newUnion(int lgK) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)TgtHllType.HLL_8);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        return new Union(lgK, wmem);
    }

    private static double getBound(int lgK, boolean ub, boolean oooFlag, int numStdDev, double est) {
        double re = RelativeErrorTables.getRelErr((boolean)ub, (boolean)oooFlag, (int)lgK, (int)numStdDev);
        return est / (1.0 + re);
    }

    @Test
    public void printlnTest() {
        DirectUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DirectUnionTest.print(s + LS);
    }

    static void print(String s) {
    }
}

