/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.jiter;

import java.util.Iterator;
import java.util.function.Function;

public class MappingJavaIterator<S, T>
implements Iterator<T> {
    private final Iterator<S> input;
    private final Function<S, T> mapper;
    private T nextItem;

    public MappingJavaIterator(Iterator<S> in, Function<S, T> mapper) {
        this.input = in;
        this.mapper = mapper;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public T next() {
        T result = this.nextItem;
        if (result != null) {
            this.advance();
        }
        return result;
    }

    private void advance() {
        while (this.input.hasNext()) {
            this.nextItem = this.mapper.apply(this.input.next());
            if (this.nextItem == null) continue;
            return;
        }
        this.nextItem = null;
    }

    @Override
    public void remove() {
        this.input.remove();
    }
}

