/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntFunction;

public final class ConcurrentAppendOnlyChunkedList<E> {
    private static final AtomicLongFieldUpdater<ConcurrentAppendOnlyChunkedList> LAST_INDEX_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcurrentAppendOnlyChunkedList.class, "lastIndex");
    private final int chunkSize;
    private final int chunkMask;
    private final int chunkSizeLog2;
    private AtomicChunk<E> firstBuffer = null;
    private AtomicChunk<E> lastBuffer = null;
    private volatile long lastIndex = 0L;

    public ConcurrentAppendOnlyChunkedList(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be >0");
        }
        if (Integer.bitCount(chunkSize) != 1) {
            throw new IllegalArgumentException("chunkSize must be a power of 2");
        }
        this.chunkSize = chunkSize;
        this.chunkMask = chunkSize - 1;
        this.chunkSizeLog2 = Integer.numberOfTrailingZeros(chunkSize);
    }

    private long getValidLastIndex() {
        return this.lastIndex >> 1;
    }

    public int size() {
        return (int)this.getValidLastIndex();
    }

    public void addAll(E[] elements) {
        for (E e : elements) {
            this.add(e);
        }
    }

    public E get(int index) {
        AtomicChunk<E> buffer;
        int offset;
        if (index < 0) {
            return null;
        }
        long lastIndex = this.getValidLastIndex();
        if ((long)index >= lastIndex) {
            return null;
        }
        if (index >= this.chunkSize) {
            offset = index & this.chunkMask;
            buffer = this.getChunkOf(index, lastIndex);
        } else {
            offset = index;
            buffer = this.firstBuffer;
        }
        return ConcurrentAppendOnlyChunkedList.pollElement(buffer, offset);
    }

    private AtomicChunk<E> getChunkOf(int index, long lastIndex) {
        int chunkSizeLog2 = this.chunkSizeLog2;
        int chunkIndex = index >> chunkSizeLog2;
        int lastChunkIndex = (int)lastIndex >> chunkSizeLog2;
        int distance = chunkIndex;
        AtomicChunk<E> buffer = null;
        boolean forward = true;
        int distanceFromLast = lastChunkIndex - chunkIndex;
        if (distanceFromLast < distance) {
            AtomicChunk<E> lastBuffer = this.lastBuffer;
            distanceFromLast = lastBuffer.index - chunkIndex;
            if (distanceFromLast < distance) {
                buffer = lastBuffer;
                distance = distanceFromLast;
                forward = false;
            }
        }
        if (buffer == null) {
            buffer = this.firstBuffer;
        }
        for (int i = 0; i < distance; ++i) {
            buffer = forward ? buffer.next : buffer.prev;
        }
        return buffer;
    }

    public void add(E e) {
        int offset;
        AtomicChunk<E> lastBuffer;
        Objects.requireNonNull(e);
        while (true) {
            long lastIndex;
            if (((lastIndex = this.lastIndex) & 1L) == 1L) {
                continue;
            }
            long validLastIndex = lastIndex >> 1;
            if (validLastIndex == Integer.MAX_VALUE) {
                throw new IllegalStateException("can't add more then 2147483647 elements");
            }
            lastBuffer = this.lastBuffer;
            offset = (int)(validLastIndex & (long)this.chunkMask);
            if (offset == 0) {
                if (!this.addChunkAndElement(lastBuffer, lastIndex, validLastIndex, e)) continue;
                return;
            }
            if (LAST_INDEX_UPDATER.compareAndSet(this, lastIndex, lastIndex + 2L)) break;
        }
        lastBuffer.lazySet(offset, e);
    }

    private boolean addChunkAndElement(AtomicChunk<E> lastBuffer, long lastIndex, long validLastIndex, E element) {
        AtomicChunk<E> newChunk;
        if (!LAST_INDEX_UPDATER.compareAndSet(this, lastIndex, lastIndex + 1L)) {
            return false;
        }
        try {
            int index = (int)(validLastIndex >> this.chunkSizeLog2);
            newChunk = new AtomicChunk<E>(index, lastBuffer, this.chunkSize);
        }
        catch (OutOfMemoryError oom) {
            LAST_INDEX_UPDATER.lazySet(this, lastIndex);
            throw oom;
        }
        newChunk.lazySet(0, element);
        if (lastBuffer != null) {
            lastBuffer.next = newChunk;
        } else {
            this.firstBuffer = newChunk;
        }
        this.lastBuffer = newChunk;
        LAST_INDEX_UPDATER.lazySet(this, lastIndex + 2L);
        return true;
    }

    public E[] toArray(IntFunction<E[]> arrayAllocator) {
        return this.toArray(arrayAllocator, 0);
    }

    public E[] toArray(IntFunction<E[]> arrayAllocator, int startIndex) {
        if (startIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("startIndex must be >= 0");
        }
        long lastIndex = this.getValidLastIndex();
        assert (lastIndex <= Integer.MAX_VALUE);
        int size = (int)lastIndex;
        E[] elements = arrayAllocator.apply(size);
        if (startIndex + size > elements.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int chunkSize = this.chunkSize;
        int chunks = size > chunkSize ? size >> this.chunkSizeLog2 : 0;
        AtomicChunk<E> buffer = this.firstBuffer;
        int elementIndex = startIndex;
        for (int i = 0; i < chunks; ++i) {
            ConcurrentAppendOnlyChunkedList.drain(buffer, elements, elementIndex, chunkSize);
            elementIndex += chunkSize;
            buffer = buffer.next;
        }
        int remaining = chunks > 0 ? size & this.chunkMask : size;
        ConcurrentAppendOnlyChunkedList.drain(buffer, elements, elementIndex, remaining);
        return elements;
    }

    private static <E> E pollElement(AtomicChunk<E> buffer, int i) {
        Object e;
        while ((e = buffer.get(i)) == null) {
        }
        return e;
    }

    private static <E> void drain(AtomicChunk<E> buffer, E[] elements, int elementNumber, int length) {
        for (int j = 0; j < length; ++j) {
            E e = ConcurrentAppendOnlyChunkedList.pollElement(buffer, j);
            assert (e != null);
            elements[elementNumber] = e;
            ++elementNumber;
        }
    }

    private static final class AtomicChunk<E>
    extends AtomicReferenceArray<E> {
        AtomicChunk<E> next = null;
        final AtomicChunk<E> prev;
        final int index;

        AtomicChunk(int index, AtomicChunk<E> prev, int length) {
            super(length);
            this.index = index;
            this.prev = prev;
        }
    }
}

