/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationDepUtils {
    private static Logger logger = Logger.getLogger(AnnotationDepUtils.class);

    public static String getTokenRelTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation[] annotations, String[] labels) {
        return AnnotationDepUtils.getTokenRelTreeString(jCas, nodes, annotations, labels, false);
    }

    public static String getTokenRelTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation[] annotations, String[] labels, boolean getParent) {
        HashMap<ConllDependencyNode, SimpleTree> node2tree = new HashMap<ConllDependencyNode, SimpleTree>();
        ConllDependencyNode topNode = null;
        for (ConllDependencyNode node : nodes) {
            if (node.getHead() == null) {
                topNode = node;
                continue;
            }
            SimpleTree curTree = null;
            SimpleTree headTree = null;
            if (!node2tree.containsKey(node)) {
                curTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getDeprel(), node.getCoveredText()));
                node2tree.put(node, curTree);
            } else {
                curTree = (SimpleTree)node2tree.get(node);
            }
            if (curTree.parent != null || node.getHead() == null) continue;
            if (node2tree.containsKey(node.getHead())) {
                headTree = (SimpleTree)node2tree.get(node.getHead());
            } else {
                String token = node.getHead().getHead() == null ? "TOP" : node.getHead().getCoveredText();
                headTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getHead().getDeprel(), SimpleTree.escapeCat((String)token)));
                node2tree.put(node.getHead(), headTree);
            }
            curTree.parent = (SimpleTree)headTree.children.get(0);
            ((SimpleTree)headTree.children.get(0)).addChild(curTree);
        }
        ConllDependencyNode highestHead = null;
        ConllDependencyNode leftmostHead = null;
        ConllDependencyNode rightmostHead = null;
        ArrayList annotationNodes = Lists.newArrayList();
        for (int i = 0; i < annotations.length; ++i) {
            List coveredNodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)annotations[i]);
            if (coveredNodes == null || coveredNodes.size() == 0) continue;
            ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode(coveredNodes);
            if (highestHead == null || AnnotationDepUtils.distanceFromRoot(headNode) < AnnotationDepUtils.distanceFromRoot(highestHead)) {
                highestHead = headNode;
            }
            if (leftmostHead == null || headNode.getBegin() < leftmostHead.getBegin()) {
                leftmostHead = headNode;
            }
            if (rightmostHead == null || headNode.getEnd() > rightmostHead.getEnd()) {
                rightmostHead = headNode;
            }
            SimpleTree insertionPoint = (SimpleTree)node2tree.get(headNode);
            SimpleTree insertingTree = new SimpleTree(insertionPoint.cat);
            insertionPoint.cat = labels[i];
            insertingTree.children = insertionPoint.children;
            ((SimpleTree)insertingTree.children.get((int)0)).parent = insertingTree;
            insertionPoint.children = new ArrayList();
            insertionPoint.addChild(insertingTree);
            insertingTree.parent = insertionPoint;
            annotationNodes.add(insertionPoint);
        }
        if (highestHead == null) {
            return null;
        }
        SimpleTree root = (SimpleTree)node2tree.get(topNode);
        SimpleTree leftmostNode = AnnotationDepUtils.getLeftmostNode(root, Sets.newHashSet((Object[])labels));
        SimpleTree rightmostNode = AnnotationDepUtils.getRightmostNode(root, Sets.newHashSet((Object[])labels));
        SimpleTree pet = AnnotationDepUtils.getPathEnclosedTree(root, annotationNodes, leftmostNode, rightmostNode);
        if (getParent && pet.parent != null) {
            pet = pet.parent;
        }
        String treeStr = pet.toString();
        treeStr = treeStr.replaceAll("\\(([^\\(]+) \\)", "($1 nil)").toLowerCase();
        return treeStr;
    }

    private static SimpleTree getRightmostNode(SimpleTree root, Set<String> labels) {
        SimpleTree node = null;
        for (int i = root.children.size() - 1; i >= 0; --i) {
            if (labels.contains(((SimpleTree)root.children.get((int)i)).cat)) {
                node = (SimpleTree)root.children.get(i);
                break;
            }
            node = AnnotationDepUtils.getRightmostNode((SimpleTree)root.children.get(i), labels);
            if (node != null) break;
        }
        return node;
    }

    private static SimpleTree getLeftmostNode(SimpleTree root, Set<String> labels) {
        SimpleTree node = null;
        for (int i = 0; i < root.children.size(); ++i) {
            if (labels.contains(((SimpleTree)root.children.get((int)i)).cat)) {
                node = (SimpleTree)root.children.get(i);
                break;
            }
            node = AnnotationDepUtils.getLeftmostNode((SimpleTree)root.children.get(i), labels);
            if (node != null) break;
        }
        return node;
    }

    public static String getTokenTreeString(JCas jCas, List<ConllDependencyNode> nodes, Annotation[] annotations, String[] labels, boolean getParent) {
        Map<ConllDependencyNode, SimpleTree> node2tree = AnnotationDepUtils.getNodeTreeMap(nodes);
        ConllDependencyNode topNode = AnnotationDepUtils.getTopNode(nodes);
        ConllDependencyNode highestHead = null;
        ConllDependencyNode leftmostHead = null;
        ConllDependencyNode rightmostHead = null;
        ArrayList annotationNodes = Lists.newArrayList();
        for (int i = 0; i < annotations.length; ++i) {
            List coveredNodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)annotations[i]);
            if (coveredNodes == null || coveredNodes.size() == 0) continue;
            ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode(coveredNodes);
            if (highestHead == null || AnnotationDepUtils.distanceFromRoot(headNode) < AnnotationDepUtils.distanceFromRoot(highestHead)) {
                highestHead = headNode;
            }
            if (leftmostHead == null || headNode.getBegin() < leftmostHead.getBegin()) {
                leftmostHead = headNode;
            }
            if (rightmostHead == null || headNode.getEnd() > rightmostHead.getEnd()) {
                rightmostHead = headNode;
            }
            SimpleTree insertionPoint = node2tree.get(headNode);
            SimpleTree insertingTree = new SimpleTree(insertionPoint.cat);
            insertionPoint.cat = labels[i];
            insertingTree.children = insertionPoint.children;
            ((SimpleTree)insertingTree.children.get((int)0)).parent = insertingTree;
            insertionPoint.children = new ArrayList();
            insertionPoint.addChild(insertingTree);
            insertingTree.parent = insertionPoint;
            annotationNodes.add(insertionPoint);
        }
        if (highestHead == null) {
            return null;
        }
        SimpleTree root = node2tree.get(topNode);
        SimpleTree leftmostNode = AnnotationDepUtils.getLeftmostNode(root, Sets.newHashSet((Object[])labels));
        SimpleTree rightmostNode = AnnotationDepUtils.getRightmostNode(root, Sets.newHashSet((Object[])labels));
        SimpleTree pet = AnnotationDepUtils.getPathEnclosedTree(root, annotationNodes, leftmostNode, rightmostNode);
        if (getParent && pet.parent != null) {
            pet = pet.parent;
        }
        String treeStr = pet.toString();
        treeStr = treeStr.replaceAll("\\(([^\\(]+) \\)", "($1 nil)").toLowerCase();
        return treeStr;
    }

    public static SimpleTree getPathEnclosedTree(SimpleTree root, List<SimpleTree> annotationNodes, SimpleTree leftmostTree, SimpleTree rightmostTree) {
        SimpleTree pet = null;
        Sets.SetView commonAncestors = AnnotationDepUtils.getAncestors(annotationNodes.get(0));
        for (int i = 1; i < annotationNodes.size(); ++i) {
            Set<SimpleTree> nodeAncestors = AnnotationDepUtils.getAncestors(annotationNodes.get(i));
            commonAncestors = Sets.intersection(commonAncestors, (Set)nodeAncestors);
        }
        SimpleTree lowestAncestor = null;
        for (SimpleTree ancestor : commonAncestors) {
            if (lowestAncestor != null && AnnotationDepUtils.distanceFromRoot(ancestor) <= AnnotationDepUtils.distanceFromRoot(lowestAncestor)) continue;
            lowestAncestor = ancestor;
        }
        root = lowestAncestor;
        SimpleTree curNode = leftmostTree;
        SimpleTree lastNode = null;
        while (curNode != root) {
            lastNode = curNode;
            if (curNode == null || curNode.parent == null) {
                logger.error((Object)"Something weird.");
            }
            if ((curNode = curNode.parent) == null || curNode.children == null) {
                logger.error((Object)"Something is null on the left side of the tree in PET!");
                break;
            }
            while (curNode.children.get(0) != lastNode) {
                curNode.children.remove(0);
            }
        }
        curNode = rightmostTree;
        lastNode = null;
        while (curNode != root) {
            lastNode = curNode;
            curNode = curNode.parent;
            if (curNode == null) {
                logger.error((Object)"Something is null on the right side of the tree in PET!");
                break;
            }
            if (curNode.children == null || curNode.children.size() == 0) {
                System.err.println("Help");
            }
            while (curNode.children.get(curNode.children.size() - 1) != lastNode) {
                curNode.children.remove(curNode.children.size() - 1);
                if (curNode.children != null && curNode.children.size() != 0) continue;
                System.err.println("Help");
            }
        }
        pet = lowestAncestor;
        return pet;
    }

    private static ConllDependencyNode getTopNode(List<ConllDependencyNode> nodes) {
        ConllDependencyNode topNode = null;
        for (ConllDependencyNode node : nodes) {
            if (node.getHead() != null) continue;
            topNode = node;
            break;
        }
        return topNode;
    }

    private static Map<ConllDependencyNode, SimpleTree> getNodeTreeMap(List<ConllDependencyNode> nodes) {
        HashMap node2tree = Maps.newHashMap();
        for (ConllDependencyNode node : nodes) {
            if (node.getHead() == null) continue;
            SimpleTree curTree = null;
            SimpleTree headTree = null;
            if (!node2tree.containsKey(node)) {
                curTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getDeprel(), node.getCoveredText()));
                node2tree.put(node, curTree);
            } else {
                curTree = (SimpleTree)node2tree.get(node);
            }
            if (curTree.parent != null || node.getHead() == null) continue;
            if (node2tree.containsKey(node.getHead())) {
                headTree = (SimpleTree)node2tree.get(node.getHead());
            } else {
                String token = node.getHead().getHead() == null ? "TOP" : node.getHead().getCoveredText();
                headTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getHead().getDeprel(), SimpleTree.escapeCat((String)token)));
                node2tree.put(node.getHead(), headTree);
            }
            curTree.parent = (SimpleTree)headTree.children.get(0);
            ((SimpleTree)headTree.children.get(0)).addChild(curTree);
        }
        return node2tree;
    }

    private static Set<SimpleTree> getAncestors(SimpleTree tree) {
        HashSet ancestors = Sets.newHashSet();
        while (tree != null) {
            ancestors.add(tree);
            tree = tree.parent;
        }
        return ancestors;
    }

    public static int distanceFromRoot(ConllDependencyNode node) {
        int dist = 0;
        while (node.getHead() != null) {
            ++dist;
            node = node.getHead();
        }
        return dist;
    }

    public static int distanceFromRoot(SimpleTree tree) {
        int dist = 0;
        while (tree.parent != null) {
            ++dist;
            tree = tree.parent;
        }
        return dist;
    }
}

