/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util.pooling;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class StringInternMapLRU {
    private static Logger log = Logger.getLogger("com.icesoft.faces.compat");
    private static final int DEFAULT_MAX_SIZE = 95000;
    private Map map;
    private int defaultSize;
    private String contextParam;
    private boolean disabled;

    public StringInternMapLRU() {
        this(95000);
    }

    public StringInternMapLRU(int size) {
        this(size, "");
    }

    public StringInternMapLRU(String contextParam) {
        this(95000, contextParam);
    }

    public StringInternMapLRU(int defaultSize, String contextParam) {
        this.defaultSize = defaultSize;
        this.contextParam = contextParam;
        this.disabled = false;
    }

    private void createMap() {
        String maxSizeParam;
        int maxSize = this.defaultSize;
        if (this.contextParam != null && (maxSizeParam = FacesContext.getCurrentInstance().getExternalContext().getInitParameter(this.contextParam)) != null && maxSizeParam.length() > 0) {
            int configuredMaxSize = 0;
            try {
                configuredMaxSize = Integer.parseInt(maxSizeParam);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Couldn't parse context-param: " + this.contextParam + ".", e);
            }
            if (configuredMaxSize > 0) {
                maxSize = configuredMaxSize;
            } else {
                this.disabled = true;
                return;
            }
        }
        int capacity = maxSize * 4 / 3 + 10;
        final int finalSize = maxSize;
        this.map = Collections.synchronizedMap(new LinkedHashMap(capacity, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > finalSize;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object value) {
        if (this.map == null && !this.disabled) {
            StringInternMapLRU stringInternMapLRU = this;
            synchronized (stringInternMapLRU) {
                if (this.map == null && !this.disabled) {
                    this.createMap();
                }
            }
        }
        if (this.disabled) {
            return value;
        }
        if (value == null) {
            return null;
        }
        Object pooledValue = this.map.get(value);
        if (pooledValue != null) {
            return pooledValue;
        }
        this.map.put(value, value);
        return value;
    }

    public int getSize() {
        if (this.map == null || this.disabled) {
            return 0;
        }
        return this.map.size();
    }
}

