/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentListNode {
    private char key_ = (char)32;
    private long address_ = -1L;
    private long next_ = -1L;

    public PersistentListNode() {
    }

    public PersistentListNode(long address) {
        this.address_ = address;
    }

    public PersistentListNode(long address, long next) {
        this.next_ = next;
        this.address_ = address;
    }

    public void SetNext(long next) {
        this.next_ = next;
    }

    public long GetNext() {
        return this.next_;
    }

    public void SetAddress(long address) {
        this.address_ = address;
    }

    public long GetAddress() {
        return this.address_;
    }

    public void WriteData(RandomAccessFile raf) throws IOException {
    }

    public void ReadData(RandomAccessFile raf) throws IOException {
    }

    public static PersistentListNode GetNode(RandomAccessFile raf, long address) throws IOException {
        raf.seek(address);
        PersistentListNode node = new PersistentListNode(address);
        node.ReadData(raf);
        long next = raf.readLong();
        node.SetNext(next);
        return node;
    }

    public static void PrintList(RandomAccessFile raf, long address) throws IOException {
        raf.seek(address);
        int nodeNum = raf.readInt();
        long curAddress = address + 12L;
        System.out.println("--- List contains " + nodeNum + " nodes, start@" + address);
        int i = 0;
        while (curAddress != -1L) {
            PersistentListNode curNode = PersistentListNode.GetNode(raf, curAddress);
            System.out.println(i + ": '" + curNode.GetAddress() + "')");
            curAddress = curNode.GetNext();
            ++i;
        }
    }
}

