/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp;

import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgDef;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.Handler;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.LibCloseableFrame;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class InflectionPanel
extends JPanel {
    private JCheckBox[] cb_ = new JCheckBox[LvgDef.INFLECTION_NUM];
    private static final long serialVersionUID = 5L;

    public InflectionPanel(ActionListener target, int col) {
        int row = (int)Math.ceil((double)LvgDef.INFLECTION_NUM / (double)col);
        this.setLayout(new GridLayout(row, col, 5, 3));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inflections"));
        for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
            this.cb_[i] = new JCheckBox(LvgDef.INFLECTION[i] + " (" + LvgDef.INFLECTION_VALUE[i] + ")");
            this.cb_[i].addActionListener(target);
            this.add(this.cb_[i]);
        }
    }

    public void UpdateCheckBox(long cat) {
        for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
            Vector<Long> catValues = Category.ToValues(cat);
            boolean flag = false;
            for (int j = 0; j < catValues.size(); ++j) {
                long curCat = catValues.elementAt(j);
                flag = flag || CatInfl.IsRelated(curCat, Inflection.GetBitValue(i));
            }
            this.cb_[i].setEnabled(flag);
        }
    }

    public void ResetCheckBox() {
        for (int i = 0; i < LvgDef.INFLECTION_NUM; ++i) {
            this.cb_[i].setEnabled(true);
        }
    }

    public JCheckBox[] GetCheckBox() {
        return this.cb_;
    }

    public static void main(String[] args) {
        LibCloseableFrame frame = new LibCloseableFrame("Inflection Panel");
        frame.setContentPane(new InflectionPanel(new Handler(), 3));
        frame.setSize(900, 250);
        frame.setVisible(true);
    }
}

