/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.CmdLineTools;

import gov.nih.nlm.nls.lvg.Api.ToAsciiApi;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Tools.CmdLineTools.ToAsciiHelp;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class toAscii
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private boolean detailsFlag_ = false;
    private boolean runFlag_ = true;
    private boolean noOutputFlag_ = false;
    private boolean promptFlag_ = false;
    private boolean preserveIoFlag_ = false;
    private boolean fileOutput_ = false;
    private String noOutputStr_ = "-No Output-";
    private String configFile_ = null;
    private String promptStr_ = null;
    private Configuration conf_ = null;
    private ToAsciiApi toAsciiApi_ = null;
    private BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;

    public toAscii() {
        this.Init();
    }

    public static void main(String[] args) {
        Option io = Option.GetOptonByArgs(args);
        toAscii toAsciiObj = new toAscii();
        Out out = new Out();
        if (SystemOption.CheckSyntax(io, toAsciiObj.GetOption(), false, true)) {
            toAsciiObj.ExecuteCommands(io, toAsciiObj.GetOption(), out);
            toAsciiObj.GetConfig();
            toAsciiObj.InitByConfig(toAsciiObj, out);
        } else {
            ToAsciiHelp.ToAsciiHelp(toAsciiObj.GetOutWriter(), toAsciiObj.GetFileOutput(), out);
        }
        toAsciiObj.Close();
    }

    public void GetVariants(Out out) {
        if (this.inReader_ == null) {
            try {
                this.inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        try {
            do {
                if (!this.promptFlag_) continue;
                this.GetPrompt(out);
            } while (this.LineHandler(this.inReader_.readLine(), out));
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption, Out out) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (toAscii.CheckOption(nameItem, "-ci")) {
            try {
                Configuration conf;
                boolean useClassPath = false;
                String configFile = this.configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lvg";
                }
                if ((conf = this.conf_) == null) {
                    conf = new Configuration(configFile, useClassPath);
                }
                out.Println(this.outWriter_, conf.GetInformation(), this.fileOutput_, false);
            }
            catch (IOException useClassPath) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-d")) {
            this.detailsFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-h")) {
            ToAsciiHelp.ToAsciiHelp(this.outWriter_, this.fileOutput_, out);
            this.runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    this.inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (toAscii.CheckOption(nameItem, "-n")) {
            this.noOutputFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    this.fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (toAscii.CheckOption(nameItem, "-p")) {
            this.promptFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-pio")) {
            this.preserveIoFlag_ = true;
        } else if (toAscii.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "toAscii.2016";
                out.Println(this.outWriter_, releaseStr, this.fileOutput_, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (toAscii.CheckOption(nameItem, "-x:STR")) {
            this.configFile_ = nameItem.GetOptionArgument();
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-ci -d -h -hs -i:STR -n -o:STR -p -pio -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-ci", "Print_Config_Info");
        this.systemOption_.SetFlagFullName("-d", "Print_Operation_Details");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-pio", "Preserve_IO");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private void Close() {
        try {
            if (this.outWriter_ != null) {
                this.outWriter_.close();
            }
            if (this.inReader_ != null) {
                this.inReader_.close();
            }
        }
        catch (Exception e) {
            System.err.println("Err@toAscii.Close(): " + e.toString());
        }
    }

    private void GetPrompt(Out out) throws IOException {
        out.Println(this.outWriter_, this.promptStr_, this.fileOutput_, false);
    }

    private boolean LineHandler(String line, Out out) throws IOException {
        if (line == null) {
            return false;
        }
        LexItem inLexItem = new LexItem(line);
        LexItem outLexItem = this.toAsciiApi_.Mutate(inLexItem, this.detailsFlag_);
        if (this.noOutputFlag_ && outLexItem.GetTargetTerm().length() == 0) {
            if (this.preserveIoFlag_) {
                out.Println(this.outWriter_, "Input: " + line, this.fileOutput_, false);
                out.Println(this.outWriter_, "Ascii: " + this.noOutputStr_, this.fileOutput_, false);
            } else {
                out.Println(this.outWriter_, this.noOutputStr_, this.fileOutput_, false);
            }
        } else {
            if (this.preserveIoFlag_) {
                out.Println(this.outWriter_, "Input: " + line, this.fileOutput_, false);
                out.Println(this.outWriter_, "Ascii: " + outLexItem.GetTargetTerm(), this.fileOutput_, false);
            } else {
                out.Println(this.outWriter_, outLexItem.GetTargetTerm(), this.fileOutput_, false);
            }
            if (this.detailsFlag_) {
                out.Println(this.outWriter_, outLexItem.GetDetailInformation(), this.fileOutput_, false);
            }
        }
        return true;
    }

    private boolean GetFileOutput() {
        return this.fileOutput_;
    }

    private BufferedWriter GetOutWriter() {
        return this.outWriter_;
    }

    private void Init() {
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        try {
            this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }

    private void GetConfig() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        if (this.conf_ == null) {
            this.conf_ = new Configuration(this.configFile_, useClassPath);
        }
    }

    private void InitByConfig(toAscii toAsciiObj, Out out) {
        if (this.conf_.GetSize() <= 0) {
            this.runFlag_ = false;
        } else {
            this.toAsciiApi_ = new ToAsciiApi(this.conf_);
            if (this.conf_.GetConfiguration("NO_OUTPUT") != null) {
                this.noOutputStr_ = this.conf_.GetConfiguration("NO_OUTPUT");
            }
            if (!this.conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                this.promptStr_ = this.conf_.GetConfiguration("LVG_PROMPT");
            }
            if (this.runFlag_) {
                toAsciiObj.GetVariants(out);
            }
        }
    }
}

