/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Util.Vec;
import java.util.ArrayList;
import java.util.Vector;

public class Inflection
extends BitMaskBase {
    public static final int BASE_BIT = 0;
    public static final int COMPARATIVE_BIT = 1;
    public static final int SUPERLATIVE_BIT = 2;
    public static final int PLURAL_BIT = 3;
    public static final int PRES_PART_BIT = 4;
    public static final int PAST_BIT = 5;
    public static final int PAST_PART_BIT = 6;
    public static final int PRES_3S_BIT = 7;
    public static final int POSITIVE_BIT = 8;
    public static final int SINGULAR_BIT = 9;
    public static final int INFINITIVE_BIT = 10;
    public static final int PRES_1_2_3P_BIT = 11;
    public static final int PAST_NEG_BIT = 12;
    public static final int PRES_1_2_3P_NEG_BIT = 13;
    public static final int PRES_1S_BIT = 14;
    public static final int PAST_1P_2_3P_NEG_BIT = 15;
    public static final int PAST_1P_2_3P_BIT = 16;
    public static final int PAST_1S_3S_NEG_BIT = 17;
    public static final int PRES_1P_2_3P_BIT = 18;
    public static final int PRES_1P_2_3P_NEG_BIT = 19;
    public static final int PAST_1S_3S_BIT = 20;
    public static final int PRES_BIT = 21;
    public static final int PRES_3S_NEG_BIT = 22;
    public static final int PRES_NEG_BIT = 23;
    public static final long LOWER_INFLECTIONS = 255L;
    public static final long UPPER_INFLECTIONS = 0xFFFE00L;
    public static final int SIMPLE_BITS = 7;
    public static final int TOTAL_BITS = 24;
    public static final long ALL_BIT_VALUE = 0xFFFFFFL;
    public static final long NO_BIT_VALUE = 0L;
    public static final long[] MAP_SIMPLE_INFL = new long[]{MASK[0], MASK[1], MASK[2], MASK[3], MASK[4], MASK[5], MASK[6], MASK[7], MASK[0], MASK[0], MASK[0], MASK[0], MASK[5], MASK[21], MASK[21], MASK[5], MASK[5], MASK[5], MASK[21], MASK[21], MASK[5], MASK[21], MASK[21], MASK[21]};
    private static final ArrayList<Vector<String>> BIT_STR = new ArrayList(63);

    public Inflection() {
        super(0xFFFFFFL, BIT_STR);
    }

    public Inflection(long value) {
        super(value, 0xFFFFFFL, BIT_STR);
    }

    public static long ToValue(String valueStr) {
        long value = Inflection.ToValue(valueStr, BIT_STR);
        return value;
    }

    public static String ToName(long value) {
        String valueStr = Inflection.ToName(value, 0xFFFFFFL, BIT_STR);
        return valueStr;
    }

    public static String GetBitName(int bitValue) {
        return Inflection.GetBitName(bitValue, 0);
    }

    public static String GetBitName(int bitValue, int index) {
        return Inflection.GetBitName(bitValue, index, BIT_STR);
    }

    public static long Enumerate(String valueStr) {
        return Inflection.Enumerate(valueStr, BIT_STR);
    }

    public static Vector<Long> ToValues(long value) {
        return Inflection.ToValues(value, 24);
    }

    public static long[] ToValuesArray(long value) {
        Vector<Long> out = Inflection.ToValues(value, 24);
        return Vec.ToArray(out);
    }

    public static void main(String[] args) {
        String foo = "base+singular+plural+infinitive+pres+past+presPart+pastPart+positive+comparative+superlative";
        System.out.println(" -  ToValue(" + foo + "): " + Inflection.ToValue(foo));
        System.out.println(" -  ToName(2099071): " + Inflection.ToName(2099071L));
        foo = "base+singular+infinitive+positive";
        System.out.println(" -  ToValue(" + foo + "): " + Inflection.ToValue(foo));
        System.out.println(" -  ToName(1793): " + Inflection.ToName(1793L));
        Vector<Long> values = Inflection.ToValues(1793L);
        for (int i = 0; i < values.size(); ++i) {
            System.out.println(" - Inflection.ToValues(1793): " + values.elementAt(i));
        }
        long[] valuesArray = Inflection.ToValuesArray(1793L);
        for (int i = 0; i < valuesArray.length; ++i) {
            System.out.println(" - Inflection.ToValues(1793): " + valuesArray[i]);
        }
        System.out.println(" -  Category.ToName(2047): " + Category.ToName(2047L));
    }

    static {
        for (int i = 0; i < 63; ++i) {
            BIT_STR.add(i, new Vector());
        }
        BIT_STR.get(0).addElement("base");
        BIT_STR.get(1).addElement("comparative");
        BIT_STR.get(2).addElement("superlative");
        BIT_STR.get(3).addElement("plural");
        BIT_STR.get(3).addElement("p");
        BIT_STR.get(4).addElement("presPart");
        BIT_STR.get(4).addElement("ing");
        BIT_STR.get(5).addElement("past");
        BIT_STR.get(6).addElement("pastPart");
        BIT_STR.get(7).addElement("pres3s");
        BIT_STR.get(8).addElement("positive");
        BIT_STR.get(9).addElement("singular");
        BIT_STR.get(9).addElement("s");
        BIT_STR.get(10).addElement("infinitive");
        BIT_STR.get(10).addElement("inf");
        BIT_STR.get(11).addElement("pres123p");
        BIT_STR.get(12).addElement("pastNeg");
        BIT_STR.get(13).addElement("pres123pNeg");
        BIT_STR.get(14).addElement("pres1s");
        BIT_STR.get(15).addElement("past1p23pNeg");
        BIT_STR.get(16).addElement("past1p23p");
        BIT_STR.get(17).addElement("past1s3sNeg");
        BIT_STR.get(18).addElement("pres1p23p");
        BIT_STR.get(19).addElement("pres1p23pNeg");
        BIT_STR.get(20).addElement("past1s3s");
        BIT_STR.get(21).addElement("pres");
        BIT_STR.get(22).addElement("pres3sNeg");
        BIT_STR.get(23).addElement("presNeg");
    }
}

