/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbProperNoun;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFilterProperNoun
extends Transformation
implements Cloneable {
    private static final String INFO = "Filter Proper Noun";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        boolean isProperNoun = ToFilterProperNoun.IsProperNoun(in.GetSourceTerm(), conn);
        Vector<LexItem> out = new Vector<LexItem>();
        if (!isProperNoun) {
            String term = in.GetSourceTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            LexItem temp = ToFilterProperNoun.UpdateLexItem(in, term, 30, 2047L, 0xFFFFFFL, details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFilterProperNoun.GetTestStr(args, "Adam");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToFilterProperNoun.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFilterProperNoun.PrintResults(in, outs);
    }

    private static boolean IsProperNoun(String inStr, Connection conn) {
        boolean isProperNoun = false;
        try {
            isProperNoun = DbProperNoun.IsProperNoun(inStr, conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return isProperNoun;
    }
}

