/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFilter
extends Transformation
implements Cloneable {
    private static final String INFO = "Filter Output";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<InflectionRecord> catInflRec = ToFilter.GetCatInfl(in.GetSourceTerm(), conn);
        Vector<InflectionRecord> combined = new Vector<InflectionRecord>();
        for (int i = 0; i < catInflRec.size(); ++i) {
            InflectionRecord record = catInflRec.elementAt(i);
            ToFilter.AddRecordToCombined(record, combined);
        }
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < combined.size(); ++i) {
            InflectionRecord record = combined.elementAt(i);
            String term = record.GetInflectedTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                mutate = Category.ToName(record.GetCategory()) + fs + Inflection.ToName(record.GetInflection()) + fs;
            }
            LexItem temp = ToFilter.UpdateLexItem(in, term, 29, record.GetCategory(), record.GetInflection(), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFilter.GetTestStr(args, "bloom");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToFilter.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFilter.PrintResults(in, outs);
    }

    private static void AddRecordToCombined(InflectionRecord record, Vector<InflectionRecord> combined) {
        if (combined.size() == 0) {
            combined.addElement(record);
        } else {
            boolean recordExist = false;
            for (int i = 0; i < combined.size(); ++i) {
                InflectionRecord cur = combined.elementAt(i);
                if (!cur.GetInflectedTerm().equalsIgnoreCase(record.GetInflectedTerm())) continue;
                recordExist = true;
                cur.SetCategory(Bit.Add(cur.GetCategory(), record.GetCategory()));
                cur.SetInflection(Bit.Add(cur.GetInflection(), record.GetInflection()));
                break;
            }
            if (!recordExist) {
                combined.addElement(record);
            }
        }
    }

    private static Vector<InflectionRecord> GetCatInfl(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflection.GetCatInfl(inStr, conn);
        return out;
    }
}

