/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToUnicodeCoreNorm;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.Hashtable;
import java.util.Vector;

public class ToAsciiApi {
    private String configFile_ = null;
    private Configuration conf_ = null;
    private Hashtable<String, String> properties_ = null;
    private Hashtable<Character, String> symbolMap_ = null;
    private Hashtable<Character, String> unicodeMap_ = null;
    private Hashtable<Character, String> ligatureMap_ = null;
    private Hashtable<Character, Character> diacriticMap_ = null;
    private Hashtable<Character, String> nonStripMap_ = null;

    public ToAsciiApi() {
        this.Init();
    }

    public ToAsciiApi(String configFile) {
        this.configFile_ = configFile;
        this.Init();
    }

    public ToAsciiApi(Configuration conf) {
        this.conf_ = conf;
        this.Init();
    }

    public ToAsciiApi(Hashtable<String, String> properties) {
        this.properties_ = properties;
        this.Init();
    }

    public ToAsciiApi(String configFile, Hashtable<String, String> properties) {
        this.configFile_ = configFile;
        this.properties_ = properties;
        this.Init();
    }

    public String Mutate(String inTerm) {
        LexItem in = new LexItem(inTerm);
        LexItem out = this.Mutate(in);
        String outStr = out.GetTargetTerm();
        return outStr;
    }

    public LexItem Mutate(LexItem in) {
        boolean showDetails = false;
        LexItem out = this.Mutate(in, showDetails);
        return out;
    }

    public LexItem Mutate(LexItem in, boolean showDetails) {
        Vector outs = new Vector();
        Vector<LexItem> outs1 = ToUnicodeCoreNorm.Mutate(in, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, showDetails, false);
        LexItem out1 = outs1.elementAt(0);
        LexItem in1 = LexItem.TargetToSource(out1);
        Vector<LexItem> outs2 = ToStripMapUnicode.Mutate(in1, this.nonStripMap_, showDetails, false);
        LexItem out = new LexItem();
        if (outs2.size() > 0) {
            out = outs2.elementAt(0);
        }
        return out;
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    private void Init() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        if (this.conf_ == null) {
            this.conf_ = new Configuration(this.configFile_, useClassPath);
        }
        if (this.properties_ != null) {
            this.conf_.OverwriteProperties(this.properties_);
        }
        String lvgDir = this.conf_.GetConfiguration("LVG_DIR");
        if (this.symbolMap_ == null) {
            this.symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(this.conf_);
        }
        if (this.unicodeMap_ == null) {
            this.unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(this.conf_);
        }
        if (this.ligatureMap_ == null) {
            this.ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(this.conf_);
        }
        if (this.diacriticMap_ == null) {
            this.diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(this.conf_);
        }
        if (this.nonStripMap_ == null) {
            this.nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(this.conf_);
        }
    }
}

