/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.piper;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ctakes.gui.pipeline.piper.PiperInfo;
import org.apache.log4j.Logger;

public class PiperFinder {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFinder");
    private final Collection<PiperInfo> _piperFiles = new ArrayList<PiperInfo>();
    private boolean _didScan = false;

    public synchronized void reset() {
        this._piperFiles.clear();
        this._didScan = false;
    }

    public synchronized Collection<PiperInfo> getPiperInfos() {
        this.scan();
        return this._piperFiles;
    }

    public synchronized void scan() {
        if (this._didScan) {
            return;
        }
        FastClasspathScanner scanner = new FastClasspathScanner(new String[0]);
        LOGGER.info((Object)"Starting Scan for Piper Filess");
        try {
            scanner.matchFilenameExtension("piper", (FileMatchProcessorWithContext)new PiperAdder());
            ScanResult scanResult = scanner.scan();
        }
        catch (ScanInterruptedException siE) {
            LOGGER.error((Object)siE.getMessage());
        }
        LOGGER.info((Object)"Scan Finished");
        this._didScan = true;
    }

    private class PiperAdder
    implements FileMatchProcessorWithContext {
        private PiperAdder() {
        }

        public void processMatch(File classpathPrefix, String relativePath, InputStream inputStream, long lengthBytes) throws IOException {
            URL url = ClasspathUtils.getClasspathResourceURL((File)classpathPrefix, (String)relativePath);
            String fullPath = url.toExternalForm();
            String simplePath = url.getPath();
            PiperFinder.this._piperFiles.add(new PiperInfo(fullPath, simplePath));
        }
    }
}

