/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.log4j.Logger;

public final class TuiTableModel
implements TableModel {
    private static final Logger LOGGER = Logger.getLogger((String)"TuiTableModel");
    public static final Tui[] CTAKES_ANAT = new Tui[]{Tui.T021, Tui.T022, Tui.T023, Tui.T024, Tui.T025, Tui.T026, Tui.T029, Tui.T030};
    private static final Tui[] CTAKES_DISO = new Tui[]{Tui.T019, Tui.T020, Tui.T037, Tui.T047, Tui.T048, Tui.T049, Tui.T050, Tui.T190, Tui.T191};
    private static final Tui[] CTAKES_FIND = new Tui[]{Tui.T033, Tui.T034, Tui.T040, Tui.T041, Tui.T042, Tui.T043, Tui.T044, Tui.T045, Tui.T046, Tui.T056, Tui.T057, Tui.T184};
    private static final Tui[] CTAKES_PROC = new Tui[]{Tui.T059, Tui.T060, Tui.T061};
    public static final Tui[] CTAKES_DRUG = new Tui[]{Tui.T109, Tui.T110, Tui.T114, Tui.T115, Tui.T116, Tui.T118, Tui.T119, Tui.T121, Tui.T122, Tui.T123, Tui.T124, Tui.T125, Tui.T126, Tui.T127, Tui.T129, Tui.T130, Tui.T131, Tui.T195, Tui.T196, Tui.T197, Tui.T200, Tui.T203};
    private static final String[] COLUMN_NAMES = new String[]{"Use", "TUI", "Semantic Type"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, String.class};
    private final EventListenerList _listenerList = new EventListenerList();
    private final Collection<Tui> _wantedTuis = EnumSet.noneOf(Tui.class);

    public TuiTableModel() {
        this._wantedTuis.addAll(Arrays.asList(CTAKES_ANAT));
        this._wantedTuis.addAll(Arrays.asList(CTAKES_DISO));
        this._wantedTuis.addAll(Arrays.asList(CTAKES_FIND));
        this._wantedTuis.addAll(Arrays.asList(CTAKES_PROC));
        this._wantedTuis.addAll(Arrays.asList(CTAKES_DRUG));
    }

    public Collection<Tui> getWantedTuis() {
        return this._wantedTuis;
    }

    @Override
    public int getRowCount() {
        return Tui.values().length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Tui tui = Tui.values()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return this.isTuiEnabled(tui);
            }
            case 1: {
                return tui.name();
            }
            case 2: {
                return tui.getDescription();
            }
        }
        return "ERROR";
    }

    private boolean isTuiEnabled(Tui tui) {
        return this._wantedTuis.contains((Object)tui);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Boolean && columnIndex == 0) {
            Tui tui = Tui.values()[rowIndex];
            if (((Boolean)aValue).booleanValue()) {
                this._wantedTuis.add(tui);
            } else {
                this._wantedTuis.remove((Object)tui);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this._listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this._listenerList.remove(TableModelListener.class, listener);
    }
}

