/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationIdCollection {
    public static final int NO_ENTITY_ID = Integer.MIN_VALUE;
    private final Map<Annotation, Integer> _entityIdMap = new HashMap<Annotation, Integer>();
    private final Map<Integer, Annotation> _idAnnotationMap = new HashMap<Integer, Annotation>();

    public AnnotationIdCollection(ArrayList<BinaryTextRelation> temporalRelation) {
        HashSet<Annotation> allAnnotations = new HashSet<Annotation>();
        for (BinaryTextRelation relation : temporalRelation) {
            allAnnotations.add(relation.getArg1().getArgument());
            allAnnotations.add(relation.getArg2().getArgument());
        }
        ArrayList annotationsList = new ArrayList(allAnnotations);
        Collections.sort(annotationsList, ArgComparator.INSTANCE);
        int id = 0;
        for (Annotation annotation : annotationsList) {
            this._entityIdMap.put(annotation, id);
            this._idAnnotationMap.put(id, annotation);
            ++id;
        }
    }

    public Set<Integer> getAnnotationIds() {
        return Collections.unmodifiableSet(new HashSet<Integer>(this._entityIdMap.values()));
    }

    public int getAnnotationId(Annotation entity) {
        Integer id = this._entityIdMap.get(entity);
        if (id != null) {
            return id;
        }
        return this.getIdByAnnotationEqual(entity);
    }

    private int getIdByAnnotationEqual(Annotation entity) {
        for (Annotation referenceAnnotation : this._entityIdMap.keySet()) {
            if (!referenceAnnotation.equals((Object)entity)) continue;
            int id = this._entityIdMap.get(referenceAnnotation);
            this._entityIdMap.put(entity, id);
            return id;
        }
        return this.getIdByTextSpan(entity.getBegin(), entity.getEnd());
    }

    private int getIdByTextSpan(int begin, int end) {
        for (Annotation referenceAnnotation : this._entityIdMap.keySet()) {
            if (referenceAnnotation.getBegin() != begin || referenceAnnotation.getEnd() != end) continue;
            return this._entityIdMap.get(referenceAnnotation);
        }
        return Integer.MIN_VALUE;
    }

    public Annotation getAnnotation(int entityId) {
        return this._idAnnotationMap.get(entityId);
    }

    public Annotation getAnnotation(Annotation entity) {
        int id = this.getAnnotationId(entity);
        if (id != Integer.MIN_VALUE) {
            return this.getAnnotation(id);
        }
        return null;
    }

    private static enum ArgComparator implements Comparator<Annotation>
    {
        INSTANCE;


        @Override
        public int compare(Annotation arg1, Annotation arg2) {
            if (arg1 == null) {
                return -1;
            }
            if (arg2 == null) {
                return 1;
            }
            int startDiff = arg1.getBegin() - arg2.getBegin();
            if (startDiff != 0) {
                return startDiff;
            }
            return arg1.getEnd() - arg2.getEnd();
        }
    }
}

