/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class THYMEData {
    public static final Set<String> SEGMENTS_TO_SKIP = Sets.newHashSet((Object[])new String[]{"20104", "20105", "20116", "20138"});
    public static final Set<Integer> TRAIN_REMAINDERS = Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3});
    public static final Set<Integer> DEV_REMAINDERS = Sets.newHashSet((Object[])new Integer[]{4, 5});
    public static final Set<Integer> TEST_REMAINDERS = Sets.newHashSet((Object[])new Integer[]{6, 7});
    public static final String[] SECTIONS = new String[]{"Train", "Dev", "Test"};

    public static List<Integer> getPatientSets(List<Integer> patientSets, Collection<Integer> remainders) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (Integer i : patientSets) {
            int remainder = i % 8;
            if (!remainders.contains(remainder)) continue;
            items.add(i);
        }
        return items;
    }

    @Deprecated
    public static List<Integer> getTrainPatientSets(List<Integer> patientSets) {
        return THYMEData.getPatientSets(patientSets, TRAIN_REMAINDERS);
    }

    @Deprecated
    public static List<Integer> getDevPatientSets(List<Integer> patientSets) {
        return THYMEData.getPatientSets(patientSets, DEV_REMAINDERS);
    }

    @Deprecated
    public static List<Integer> getTestPatientSets(List<Integer> patientSets) {
        return THYMEData.getPatientSets(patientSets, TEST_REMAINDERS);
    }

    public static List<File> getFilesFor(List<Integer> patientSets, File rawTextDirectory) {
        if (!rawTextDirectory.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : patientSets) {
            final int setNum = set;
            for (File file : rawTextDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(String.format("ID%03d", setNum));
                }
            })) {
                if (file.isHidden()) continue;
                files.add(file);
            }
        }
        return files;
    }
}

