/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.io.Files;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import scala.collection.immutable.Set;

public class ExtractDurationsUsingContainsRelation {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> files = Arrays.asList(options.getInputDirectory().listFiles());
        CollectionReader collectionReader = ExtractDurationsUsingContainsRelation.getCollectionReader(files);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(ProcessRelations.class, (Object[])new Object[]{"EventOutputFile", options.getEventOutputFile()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    public static CollectionReader getCollectionReader(List<File> inputFiles) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputFiles) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class ProcessRelations
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="EventOutputFile", mandatory=true, description="path to the output file that will store the events")
        private String eventOutputFile;
        private Map<String, HashMultiset<String>> eventTimeUnitCount;
        private File outputFile;

        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            this.eventTimeUnitCount = new HashMap<String, HashMultiset<String>>();
            this.outputFile = new File(this.eventOutputFile);
        }

        public void collectionProcessComplete() throws AnalysisEngineProcessException {
            super.collectionProcessComplete();
            for (String key : this.eventTimeUnitCount.keySet()) {
                String formatted = Utils.formatDistribution(key, (Multiset<String>)((Multiset)this.eventTimeUnitCount.get(key)), ", ", false);
                try {
                    Files.append((CharSequence)(formatted + "\n"), (File)this.outputFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    System.out.println("couldn't open output file!");
                }
            }
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
                String eventText;
                String timeText;
                if (!relation.getCategory().equals("CONTAINS")) continue;
                RelationArgument arg1 = relation.getArg1();
                RelationArgument arg2 = relation.getArg2();
                if (arg1.getArgument() instanceof TimeMention && arg2.getArgument() instanceof EventMention) {
                    timeText = arg1.getArgument().getCoveredText().toLowerCase();
                    eventText = arg2.getArgument().getCoveredText().toLowerCase();
                } else {
                    if (!(arg1.getArgument() instanceof EventMention) || !(arg2.getArgument() instanceof TimeMention)) continue;
                    eventText = arg1.getArgument().getCoveredText().toLowerCase();
                    timeText = arg2.getArgument().getCoveredText().toLowerCase();
                }
                eventText = eventText.startsWith("\n") ? eventText.substring(1) : eventText;
                Set<TemporalUnit> units = Utils.runTimexParser(timeText);
                if (units == null) continue;
                for (TemporalUnit unit : units) {
                    String coarseUnit = Utils.putInBin(unit.toString());
                    if (coarseUnit == null) continue;
                    if (this.eventTimeUnitCount.containsKey(eventText)) {
                        this.eventTimeUnitCount.get(eventText).add((Object)coarseUnit);
                        continue;
                    }
                    HashMultiset timeUnitCount = HashMultiset.create();
                    this.eventTimeUnitCount.put(eventText, (HashMultiset<String>)timeUnitCount);
                    this.eventTimeUnitCount.get(eventText).add((Object)coarseUnit);
                }
            }
        }
    }

    static interface Options {
        @Option(description="specify the path to the directory containing the xmi files")
        public File getInputDirectory();

        @Option(description="specify the path to the output file")
        public File getEventOutputFile();
    }
}

