/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.treekernel;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.treekernel.TemporalPETExtractor;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.TreeFeature;

public class TemporalFTExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public static final String FEAT_NAME = "TK_FT";

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        String timeClass;
        ArrayList<Feature> features = new ArrayList<Feature>();
        TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)arg1));
        if (root == null) {
            SimpleTree fakeTree = new SimpleTree("(S (NN null))");
            features.add((Feature)new TreeFeature(FEAT_NAME, (Object)fakeTree.toString()));
            return features;
        }
        if (arg2.getBegin() <= arg1.getBegin() && arg2.getEnd() <= arg1.getEnd()) {
            IdentifiedAnnotation temp = arg1;
            arg1 = arg2;
            arg2 = temp;
        }
        String a1type = "";
        String a2type = "";
        String eventModality = "";
        if (arg1 instanceof EventMention) {
            eventModality = ((EventMention)arg1).getEvent().getProperties().getContextualModality();
            a1type = "EVENT-" + eventModality;
        } else if (arg1 instanceof TimeMention) {
            timeClass = ((TimeMention)arg1).getTimeClass();
            a1type = "TIMEX-" + timeClass;
        }
        if (arg2 instanceof EventMention) {
            eventModality = ((EventMention)arg2).getEvent().getProperties().getContextualModality();
            a2type = "EVENT-" + eventModality;
        } else if (arg2 instanceof TimeMention) {
            timeClass = ((TimeMention)arg2).getTimeClass();
            a2type = "TIMEX-" + timeClass;
        }
        TreebankNode t1 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg1, (String)("ARG1-" + a1type));
        TreebankNode t2 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg2, (String)("ARG2-" + a2type));
        SimpleTree tree = null;
        tree = t1.getBegin() <= t2.getBegin() && t1.getEnd() >= t2.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t1) : (t2.getBegin() <= t1.getBegin() && t2.getEnd() >= t1.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t2) : TreeExtractor.getSimpleClone((TreebankNode)root));
        TemporalPETExtractor.moveTimexDownToNP(tree);
        features.add((Feature)new TreeFeature(FEAT_NAME, (Object)tree.toString()));
        return features;
    }
}

