/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class FramesetCategoryExtractor
implements FeatureExtractor1 {
    private Map<String, String> frameSetCategories;

    public FramesetCategoryExtractor() throws ResourceInitializationException {
        String path = "/org/apache/ctakes/temporal/propbank_noneventive_framesets.txt";
        URL uri = FramesetCategoryExtractor.class.getResource(path);
        this.frameSetCategories = Maps.newHashMap();
        try {
            for (String line : Resources.readLines((URL)uri, (Charset)Charsets.US_ASCII)) {
                String[] tagAndFrameset = line.split("\\s+");
                this.frameSetCategories.put(tagAndFrameset[1], tagAndFrameset[0]);
            }
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        ArrayList features = Lists.newArrayList();
        for (Predicate predicate : JCasUtil.selectCovered((JCas)view, Predicate.class, (AnnotationFS)focusAnnotation)) {
            String category = this.frameSetCategories.get(predicate.getFrameSet());
            if (category == null) continue;
            features.add(new Feature("FramesetCategory", (Object)category));
        }
        return features;
    }
}

