/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class CoordinateFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        int eventInBetween;
        int end;
        int arg2Length;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        List arg1Tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)arg1);
        List arg2Tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)arg2);
        int arg1Length = arg1Tokens == null ? 0 : arg1Tokens.size();
        int n = arg2Length = arg2Tokens == null ? 0 : arg2Tokens.size();
        if (arg1Length != arg2Length || arg1Length == 0 || arg2Length == 0) {
            return feats;
        }
        for (int i = 0; i < arg1Length; ++i) {
            if (((BaseToken)arg1Tokens.get(i)).getPartOfSpeech().equals(((BaseToken)arg2Tokens.get(i)).getPartOfSpeech())) continue;
            return feats;
        }
        int begin = arg1.getEnd();
        if (begin > (end = arg2.getBegin())) {
            begin = arg2.getEnd();
            end = arg1.getBegin();
        }
        if (begin >= end) {
            return feats;
        }
        List betweenEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (int)begin, (int)end);
        int n2 = eventInBetween = betweenEvents == null ? 0 : betweenEvents.size();
        if (eventInBetween > 0) {
            return feats;
        }
        List betweenTokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (int)begin, (int)end);
        for (BaseToken token : betweenTokens) {
            String tokenwd = token.getCoveredText();
            if (!token.getPartOfSpeech().startsWith("CC") && !tokenwd.equals(",") && !tokenwd.equals(";") && !tokenwd.equals("/") && !tokenwd.equals("w") && !tokenwd.equals("&") && !tokenwd.equalsIgnoreCase("versus") && !tokenwd.equalsIgnoreCase("vs") && !tokenwd.equalsIgnoreCase("with")) continue;
            feats.add(new Feature("Coordinate_feature", (Object)"Coordinate"));
            break;
        }
        return feats;
    }
}

