/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank.verbnet;

import com.googlecode.clearnlp.util.UTXml;
import org.w3c.dom.Element;

public class PVRole
implements Comparable<PVRole> {
    public static final String ATTR_N = "n";
    public static final String ATTR_F = "f";
    public static final String ATTR_VNTHETA = "vntheta";
    public String n;
    public String f;
    public String vntheta;

    public PVRole(Element eRole) {
        this.n = UTXml.getTrimmedAttribute(eRole, ATTR_N);
        this.f = UTXml.getTrimmedAttribute(eRole, ATTR_F);
        this.vntheta = UTXml.getTrimmedAttribute(eRole, ATTR_VNTHETA);
    }

    public PVRole(String n, String f, String vntheta) {
        this.n = n;
        this.f = f;
        this.vntheta = vntheta;
    }

    public boolean isArgN(String argn) {
        return argn.length() > 3 && this.n.equals(argn.substring(3, 4));
    }

    @Override
    public int compareTo(PVRole role) {
        int diff = this.n.compareTo(role.n);
        if (diff > 0) {
            return 1;
        }
        if (diff < 0) {
            return -1;
        }
        return this.f.compareTo(role.f);
    }

    public String toString() {
        return UTXml.startsElement(true, "role", ATTR_N, this.n, ATTR_F, this.f, ATTR_VNTHETA, this.vntheta);
    }
}

