/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.carrotsearch.hppc.IntArrayList;
import com.googlecode.clearnlp.constituent.CTLib;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.propbank.PBInstance;
import com.googlecode.clearnlp.propbank.PBLib;
import com.googlecode.clearnlp.propbank.verbnet.PVMap;
import com.googlecode.clearnlp.propbank.verbnet.PVRoles;
import com.googlecode.clearnlp.propbank.verbnet.PVRoleset;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SemlinkToOntoNotes {
    public SemlinkToOntoNotes(String ontoDir, String ontoPBFile, String semDir, String semVNFile, String pvMapFile, String outputFile) throws Exception {
        List<PBInstance> pbList = PBLib.getPBInstanceList(ontoPBFile, ontoDir, false);
        Map<String, String> semMap = this.getSemlinkMap(ontoDir, semDir, semVNFile);
        PVMap pvMap = new PVMap(new FileInputStream(pvMapFile));
        int mono = 0;
        int poly = 0;
        int subcls = 0;
        int supcls = 0;
        int none = 0;
        int skip = 0;
        for (PBInstance inst : pbList) {
            PVRoleset pvRoleset = pvMap.getRoleset(inst.roleset);
            if (pvRoleset != null) {
                PVRoles pvRoles = null;
                if (pvRoleset.size() == 1) {
                    pvRoles = pvRoleset.getSubVNRoles("");
                    inst.annotator = "mono";
                    ++mono;
                } else {
                    String vncls = semMap.get(this.getKey(inst.treePath, inst.treeId, inst.predId));
                    if (vncls != null) {
                        pvRoles = (PVRoles)pvRoleset.get(vncls);
                        if (pvRoles != null) {
                            inst.annotator = "poly";
                            ++poly;
                        } else {
                            pvRoles = pvRoleset.getSubVNRoles(vncls);
                            if (pvRoles != null) {
                                inst.annotator = "subcls";
                                ++subcls;
                            } else {
                                pvRoles = pvRoleset.getSuperVNRoles(vncls);
                                if (pvRoles != null) {
                                    inst.annotator = "supcls";
                                    ++supcls;
                                }
                            }
                        }
                    }
                }
                if (pvRoles == null) {
                    inst.annotator = "skip";
                    ++skip;
                    continue;
                }
                pvRoles.addVBRoles(inst);
                continue;
            }
            ++none;
        }
        PBLib.printPBInstances(pbList, outputFile);
        System.out.println("Total     : " + pbList.size());
        System.out.println("Mononymous: " + mono);
        System.out.println("Polysemous: " + poly);
        System.out.println("Subclass  : " + subcls);
        System.out.println("Superclass: " + supcls);
        System.out.println("Skip      : " + skip);
        System.out.println("None      : " + none);
    }

    Map<String, String> getSemlinkMap(String ontoDir, String semDir, String semVNFile) throws Exception {
        String line;
        BufferedReader fin = UTInput.createBufferedFileReader(semVNFile);
        CTReader reader1 = new CTReader();
        CTReader reader2 = new CTReader();
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> skipPaths = new HashSet<String>();
        String ontoPath = "";
        String semPath = "";
        int prevId = -1;
        CTTree tree1 = null;
        CTTree tree2 = null;
        while ((line = fin.readLine()) != null) {
            String[] tmp = line.split(" ");
            if (skipPaths.contains(tmp[0])) continue;
            if (!semPath.equals(tmp[0])) {
                ontoPath = UTFile.replaceExtension("nw" + File.separator + tmp[0], "parse");
                if (!new File(ontoDir + File.separator + ontoPath).exists()) {
                    skipPaths.add(tmp[0]);
                    continue;
                }
                semPath = tmp[0];
                prevId = -1;
                reader1.close();
                reader2.close();
                reader1.open(UTInput.createBufferedFileReader(ontoDir + File.separator + ontoPath));
                reader2.open(UTInput.createBufferedFileReader(semDir + File.separator + semPath));
            }
            int treeId = Integer.parseInt(tmp[1]);
            int predId = Integer.parseInt(tmp[2]);
            for (int i = 0; i < treeId - prevId; ++i) {
                tree1 = reader1.nextTree();
                tree2 = reader2.nextTree();
            }
            prevId = treeId;
            IntArrayList[] lists = CTLib.getTokenMapList(tree2, tree1);
            if (lists == null) {
                skipPaths.add(tmp[0]);
                continue;
            }
            IntArrayList list = lists[tree2.getTerminal(predId).getTokenId()];
            if (list.size() > 1) {
                skipPaths.add(tmp[0]);
                continue;
            }
            predId = tree1.getToken(list.get(0)).getTerminalId();
            map.put(this.getKey(ontoPath, treeId, predId), tmp[4]);
        }
        return map;
    }

    String getKey(String treePath, int treeId, int predId) {
        StringBuilder build = new StringBuilder();
        build.append(treePath);
        build.append("_");
        build.append(treeId);
        build.append("_");
        build.append(predId);
        return build.toString();
    }

    public static void main(String[] args) {
        String ontoDir = args[0];
        String ontoPBFile = args[1];
        String semDir = args[2];
        String semVNFile = args[3];
        String pvMapFile = args[4];
        String outputFile = args[5];
        try {
            new SemlinkToOntoNotes(ontoDir, ontoPBFile, semDir, semVNFile, pvMapFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

