/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;

public class DemoDEPParser {
    final String language = "en";

    public DemoDEPParser(String dictionaryFile, String posModelFile, String depModelFile, String inputFile, String outputFile) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", dictionaryFile);
        AbstractMPAnalyzer analyzer = EngineGetter.getMPAnalyzer("en", dictionaryFile);
        Pair<POSTagger[], Double> taggers = EngineGetter.getPOSTaggers(posModelFile);
        AbstractDEPParser parser = EngineGetter.getDEPParser(depModelFile);
        String sentence = "I'd like to meet Mr. Choi.";
        this.parse(tokenizer, analyzer, taggers, parser, sentence);
        this.parse(tokenizer, analyzer, taggers, parser, UTInput.createBufferedFileReader(inputFile), UTOutput.createPrintBufferedFileStream(outputFile));
    }

    public void parse(AbstractTokenizer tokenizer, AbstractMPAnalyzer analyzer, Pair<POSTagger[], Double> taggers, AbstractDEPParser parser, String sentence) {
        DEPTree tree = EngineProcess.getDEPTree(tokenizer, taggers, analyzer, parser, sentence);
        System.out.println(tree.toStringDEP() + "\n");
    }

    public void parse(AbstractTokenizer tokenizer, AbstractMPAnalyzer analyzer, Pair<POSTagger[], Double> taggers, AbstractDEPParser parser, BufferedReader reader, PrintStream fout) {
        AbstractSegmenter segmenter = EngineGetter.getSegmenter("en", tokenizer);
        for (List<String> tokens : segmenter.getSentences(reader)) {
            DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, tokens);
            fout.println(tree.toStringDEP() + "\n");
        }
        fout.close();
    }

    public static void main(String[] args) {
        String dictionaryFile = args[0];
        String posModelFile = args[1];
        String depModelFile = args[2];
        String inputFile = args[3];
        String outputFile = args[4];
        try {
            new DemoDEPParser(dictionaryFile, posModelFile, depModelFile, inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

