/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.conversion;

import com.googlecode.clearnlp.constituent.CTLibEn;
import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.conversion.AbstractC2DConverter;
import com.googlecode.clearnlp.conversion.C2DInfo;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.headrule.HeadRule;
import com.googlecode.clearnlp.headrule.HeadRuleMap;
import com.googlecode.clearnlp.headrule.HeadTagSet;
import com.googlecode.clearnlp.morphology.MPLib;
import com.googlecode.clearnlp.morphology.MPLibEn;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.pair.Pair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class EnglishC2DConverter
extends AbstractC2DConverter {
    public static final byte TYPE_STANFORD = 0;
    public static final byte TYPE_CONLL = 1;
    private final String[] a_semTags = new String[]{"BNF", "DIR", "EXT", "LOC", "MNR", "PRP", "TMP", "VOC"};
    private final String[] a_synTags = new String[]{"ADV", "CLF", "CLR", "DTV", "NOM", "PUT", "PRD", "TPC"};
    private Set<String> s_semTags;
    private Set<String> s_synTags;
    private Map<CTNode, Deque<CTNode>> m_rnr;
    private Map<CTNode, Deque<CTNode>> m_xsbj;
    private Map<String, Pattern> m_coord;
    private List<Pair<String, Set<String>>> l_mergeLabels;

    public EnglishC2DConverter(HeadRuleMap headrules, String mergeLabels) {
        super(headrules);
        this.initBasic();
        this.initCoord();
        this.initMerge(mergeLabels);
    }

    private void initBasic() {
        this.s_semTags = UTArray.toSet(this.a_semTags);
        this.s_synTags = UTArray.toSet(this.a_synTags);
        this.m_rnr = new HashMap<CTNode, Deque<CTNode>>();
        this.m_xsbj = new HashMap<CTNode, Deque<CTNode>>();
    }

    private void initCoord() {
        this.m_coord = new HashMap<String, Pattern>();
        this.m_coord.put("ADJP", Pattern.compile("^(ADJP|JJ.*|VBN|VBG)$"));
        this.m_coord.put("ADVP", Pattern.compile("^(ADVP|RB.*)$"));
        this.m_coord.put("INTJ", Pattern.compile("^(INTJ|UH)$"));
        this.m_coord.put("PP", Pattern.compile("^(PP|IN|VBG)$"));
        this.m_coord.put("PRT", Pattern.compile("^(PRT|RP)$"));
        this.m_coord.put("NAC", Pattern.compile("^(NP)$"));
        this.m_coord.put("NML", Pattern.compile("^(NP|NML|NN.*|PRP)$"));
        this.m_coord.put("NP", Pattern.compile("^(NP|NML|NN.*|PRP)$"));
        this.m_coord.put("NX", Pattern.compile("^(NX)$"));
        this.m_coord.put("VP", Pattern.compile("^(VP|VB.*)$"));
        this.m_coord.put("S", Pattern.compile("^(S|SINV|SQ|SBARQ)$"));
        this.m_coord.put("SBAR", Pattern.compile("^(SBAR.*)$"));
        this.m_coord.put("SBARQ", Pattern.compile("^(SBAR.*)$"));
        this.m_coord.put("SINV", Pattern.compile("^(S|SINV)$"));
        this.m_coord.put("SQ", Pattern.compile("^(S|SQ|SBARQ)$"));
        this.m_coord.put("WHNP", Pattern.compile("^(NN.*|WP)$"));
        this.m_coord.put("WHADJP", Pattern.compile("^(JJ.*|VBN|VBG)$"));
        this.m_coord.put("WHADVP", Pattern.compile("^(RB.*|WRB|IN)$"));
    }

    private void initMerge(String mergeLabels) {
        this.l_mergeLabels = new ArrayList<Pair<String, Set<String>>>();
        if (mergeLabels != null) {
            for (String ms : mergeLabels.split("\\|")) {
                String[] tmp = ms.split("=");
                String nLabel = tmp[0];
                HashSet<String> oLabels = new HashSet<String>();
                for (String oLabel : tmp[1].split(",")) {
                    oLabels.add(oLabel);
                }
                this.l_mergeLabels.add(new Pair(nLabel, oLabels));
            }
        }
    }

    @Override
    public DEPTree toDEPTree(CTTree cTree) {
        this.clearMaps();
        if (!this.mapEmtpyCategories(cTree)) {
            return null;
        }
        this.setHeads(cTree.getRoot());
        return this.getDEPTree(cTree);
    }

    private void clearMaps() {
        this.m_rnr.clear();
        this.m_xsbj.clear();
    }

    public boolean mapEmtpyCategories(CTTree cTree) {
        for (CTNode node : cTree.getTerminals()) {
            if (!node.isEmptyCategory() || node.getParent() == null) continue;
            if (node.form.startsWith("*PRO*")) {
                this.mapPRO(cTree, node);
                continue;
            }
            if (node.form.startsWith("*T*")) {
                this.mapTrace(cTree, node);
                continue;
            }
            if (CTLibEn.RE_NULL.matcher(node.form).find()) {
                this.mapNull(cTree, node);
                continue;
            }
            if (node.isForm("0")) continue;
            if (CTLibEn.RE_ICH_PPA_RNR.matcher(node.form).find()) {
                this.mapICH(cTree, node);
                continue;
            }
            this.removeCTNode(node);
        }
        return cTree.getRoot().getChildrenSize() > 0;
    }

    private void mapPRO(CTTree cTree, CTNode ec) {
        CTNode np = ec.getParent();
        CTNode vp = np.getParent().getFirstChainedDescendant("VP");
        if (vp == null) {
            this.relocatePRD(np, ec);
        } else {
            CTNode ante = ec.getAntecedent();
            if (ante != null && ante.pTag.startsWith("WH") && cTree.getCoIndexedEmptyCategories(ante.coIndex).size() == 1) {
                this.mapTrace(cTree, ec);
            }
            this.addXSubject(ec, this.m_xsbj);
        }
    }

    private void mapTrace(CTTree cTree, CTNode ec) {
        CTNode ante = ec.getAntecedent();
        if (ante == null || ec.isDescendantOf(ante)) {
            this.removeCTNode(ec);
        } else if (ante.hasFTag("TPC")) {
            if (!ante.hasFTag("SBJ")) {
                CTNode parent = ec.getParent();
                parent.removeChild(ec);
                this.replaceEC(parent, ante);
            } else {
                this.removeCTNode(ec);
            }
        } else {
            CTNode parent = ante.getHighestChainedAncestor("SBAR");
            if (parent != null) {
                parent.addFTag("rcmod");
            }
            this.replaceEC(ec, ante);
        }
    }

    private void mapNull(CTTree cTree, CTNode ec) {
        CTNode np = ec.getParent();
        if (np.hasFTag("SBJ")) {
            if (np.getNextSibling("VP") == null) {
                this.relocatePRD(np, ec);
            } else {
                this.addXSubject(ec, this.m_xsbj);
            }
        }
    }

    private void mapICH(CTTree cTree, CTNode ec) {
        CTNode parent = ec.getParent();
        CTNode ante = ec.getAntecedent();
        if (ec.form.startsWith("*ICH*") && parent.getPrevSibling("+WH.*") != null) {
            this.removeCTNode(ec);
        } else if (ante == null || ec.isDescendantOf(ante)) {
            this.removeCTNode(ec);
        } else {
            ArrayDeque<CTNode> dq;
            List<CTNode> list = cTree.getCoIndexedEmptyCategories(ante.coIndex);
            boolean isRNR = ec.form.startsWith("*RNR*");
            int size = list.size();
            ArrayDeque<CTNode> arrayDeque = dq = isRNR ? new ArrayDeque<CTNode>() : null;
            if (ec.getTerminalId() < ante.getFirstTerminal().getTerminalId()) {
                for (int i = 0; i < size - 1; ++i) {
                    CTNode node = list.get(i);
                    if (isRNR) {
                        dq.addLast(node.getParent().getParent());
                    }
                    this.removeCTNode(node);
                }
                ec = list.get(size - 1);
            } else {
                for (int i = size - 1; i > 0; --i) {
                    CTNode node = list.get(i);
                    if (isRNR) {
                        dq.addFirst(node.getParent().getParent());
                    }
                    this.removeCTNode(node);
                }
                ec = list.get(0);
            }
            if (isRNR && !dq.isEmpty()) {
                this.m_rnr.put(ante, dq);
            }
            parent = ec.getParent();
            parent.removeChild(ec);
            this.replaceEC(parent, ante);
        }
    }

    private void relocatePRD(CTNode np, CTNode ec) {
        CTNode s = np.getParent();
        CTNode prd = s.getFirstChild("-PRD");
        Set<String> fTags = s.getFTags();
        if (prd != null && (fTags.isEmpty() || fTags.contains("CLR"))) {
            fTags.clear();
            fTags.add("oprd");
        }
        this.removeCTNode(ec);
    }

    private void addXSubject(CTNode ec, Map<CTNode, Deque<CTNode>> map) {
        CTNode s;
        CTNode ante = ec.getAntecedent();
        while (ante != null && ante.isEmptyCategoryRec() && !ante.pTag.startsWith("WH")) {
            ante = ante.getFirstTerminal().getAntecedent();
        }
        if (ante != null && (s = ec.getNearestAncestor("S")) != null) {
            Deque<CTNode> dq = map.get(ante);
            if (dq == null) {
                dq = new ArrayDeque<CTNode>();
            }
            dq.add(s);
            map.put(ante, dq);
        }
    }

    private void removeCTNode(CTNode node) {
        CTNode parent = node.getParent();
        if (parent != null) {
            parent.removeChild(node);
            if (parent.getChildrenSize() == 0) {
                this.removeCTNode(parent);
            }
        }
    }

    private void replaceEC(CTNode ec, CTNode ante) {
        this.removeCTNode(ante);
        ec.getParent().setChild(ec.getSiblingId(), ante);
    }

    @Override
    protected void setHeadsAux(HeadRule rule, CTNode curr) {
        if (this.findHeadsCoordination(rule, curr)) {
            return;
        }
        this.findHyphens(curr);
        this.findHeadsApposition(curr);
        this.findHeadsSmallClause(curr);
        CTNode head = this.getHead(rule, curr.getChildren());
        curr.c2d = new C2DInfo(head);
    }

    private boolean findHeadsCoordination(HeadRule rule, CTNode curr) {
        int eId;
        CTNode node;
        int sId;
        int size = curr.getChildrenSize();
        for (sId = 0; sId < size && (CTLibEn.isPunctuation(node = curr.getChild(sId)) || CTLibEn.isConjunction(node)); ++sId) {
        }
        if (!CTLibEn.containsCoordination(curr, curr.getChildren(sId))) {
            return false;
        }
        Pattern rTags = this.getConjunctPattern(curr, sId, size);
        CTNode prevHead = null;
        CTNode mainHead = null;
        int bId = 0;
        boolean isFound = false;
        for (eId = sId; eId < size; ++eId) {
            node = curr.getChild(eId);
            if (CTLibEn.isCoordinator(node)) {
                if (isFound) {
                    prevHead = this.findHeadsCoordinationAux(rule, curr, bId, eId, prevHead);
                    this.setHeadCoord(node, prevHead, this.getDEPLabel(node, curr, prevHead));
                    if (mainHead == null) {
                        mainHead = prevHead;
                    }
                    isFound = false;
                    bId = eId + 1;
                    continue;
                }
                if (prevHead == null) continue;
                for (int i = bId; i <= eId; ++i) {
                    node = curr.getChild(i);
                    this.setHeadCoord(node, prevHead, this.getDEPLabel(node, curr, prevHead));
                }
                bId = eId + 1;
                continue;
            }
            if (!this.isConjunct(node, curr, rTags)) continue;
            isFound = true;
        }
        if (mainHead == null) {
            return false;
        }
        if (eId - bId > 0) {
            this.findHeadsCoordinationAux(rule, curr, bId, eId, prevHead);
        }
        curr.c2d = new C2DInfo(mainHead);
        return true;
    }

    private Pattern getConjunctPattern(CTNode curr, int sId, int size) {
        Pattern rTags = this.m_coord.get(curr.pTag);
        if (rTags != null) {
            boolean b = false;
            for (int i = sId; i < size; ++i) {
                if (!rTags.matcher(curr.getChild((int)i).pTag).find()) continue;
                b = true;
                break;
            }
            if (!b) {
                rTags = Pattern.compile(".*");
            }
        } else {
            rTags = Pattern.compile(".*");
        }
        return rTags;
    }

    private boolean isConjunct(CTNode C, CTNode P, Pattern rTags) {
        if (P.isPTag("SBAR") && C.isPTagAny("IN", "DT")) {
            return false;
        }
        if (rTags.pattern().equals(".*")) {
            return this.getSpecialLabel(C) == null;
        }
        if (rTags.matcher(C.pTag).find()) {
            if (P.isPTag("VP") && this.getAuxLabel(C) != null) {
                return false;
            }
            return !P.isPTagAny("S", "SQ", "SINV") || !C.isPTag("S") || !this.hasAdverbialTag(C);
        }
        if (P.isPTagAny("NP")) {
            return C.hasFTag("NOM");
        }
        return false;
    }

    private CTNode findHeadsCoordinationAux(HeadRule rule, CTNode curr, int bId, int eId, CTNode lastHead) {
        CTNode currHead;
        CTNode cTNode = currHead = eId - bId == 1 ? curr.getChild(bId) : this.getHead(rule, curr.getChildren(bId, eId));
        if (lastHead != null) {
            String label = "conj";
            if (this.isIntj(currHead)) {
                label = "intj";
            } else if (CTLibEn.isPunctuation(currHead)) {
                label = "punct";
            }
            this.setHeadCoord(currHead, lastHead, label);
        }
        return currHead;
    }

    private void setHeadCoord(CTNode node, CTNode head, String label) {
        if (head.isPhrase()) {
            node.c2d.setHead(head, label);
        } else {
            node.c2d.setHeadTerminal(head, label);
        }
    }

    private boolean findHyphens(CTNode node) {
        int size = node.getChildrenSize();
        boolean isFound = false;
        for (int i = 0; i < size - 2; ++i) {
            CTNode prev = node.getChild(i);
            CTNode hyph = node.getChild(i + 1);
            CTNode next = node.getChild(i + 2);
            if (!hyph.isPTag("HYPH")) continue;
            prev.c2d.setHead(next, "hmod");
            hyph.c2d.setHead(next, "hyph");
            isFound = true;
            ++i;
        }
        return isFound;
    }

    private boolean findHeadsApposition(CTNode curr) {
        CTNode fst;
        if (!curr.isPTagAny("NP", "NML") || curr.containsTags("+NN.*")) {
            return false;
        }
        for (fst = curr.getFirstChild("+NP|NML"); fst != null && fst.containsTags("POS"); fst = fst.getNextSibling("+NP|NML")) {
        }
        if (fst == null || fst.c2d.hasHead()) {
            return false;
        }
        int size = curr.getChildrenSize();
        boolean hasAppo = false;
        for (int i = fst.getSiblingId() + 1; i < size; ++i) {
            CTNode snd = curr.getChild(i);
            if (snd.c2d.hasHead() || (!snd.isPTagAny("NP", "NML") || this.hasAdverbialTag(snd)) && !snd.hasFTagAny("HLN", "TTL") && (!snd.isPTag("RRC") || !snd.containsTags("NP", "-PRD"))) continue;
            snd.c2d.setHead(fst, "appos");
            hasAppo = true;
        }
        return hasAppo;
    }

    private boolean findHeadsSmallClause(CTNode node) {
        CTNode parent = node.getParent();
        if (node.isPTag("S") && !node.containsTags("VP")) {
            CTNode sbj = node.getFirstChild("-SBJ");
            CTNode prd = node.getFirstChild("-PRD");
            if (sbj != null && prd != null) {
                CTNode vb;
                if (parent.isPTag("SQ") && (vb = parent.getFirstChild("+VB.*")) != null) {
                    sbj.c2d.setHead(vb, this.getDEPLabel(sbj, parent, vb));
                    node.pTag = prd.pTag;
                    node.addFTag("PRD");
                }
                return true;
            }
        }
        return false;
    }

    private CTNode getHead(HeadRule rule, List<CTNode> nodes) {
        int i;
        nodes = new ArrayList<CTNode>(nodes);
        if (rule.isRightToLeft()) {
            Collections.reverse(nodes);
        }
        int size = nodes.size();
        int[] flags = new int[size];
        for (i = 0; i < size; ++i) {
            flags[i] = this.getHeadFlag(nodes.get(i));
        }
        CTNode head = null;
        block1: for (int flag = 0; flag < 4; ++flag) {
            for (HeadTagSet tagset : rule.getHeadTags()) {
                for (i = 0; i < size; ++i) {
                    CTNode child = nodes.get(i);
                    if (flags[i] != flag || !tagset.matches(child)) continue;
                    head = child;
                    break block1;
                }
            }
        }
        if (head == null) {
            System.err.println("Error: head not found.");
            System.exit(1);
        }
        CTNode parent = head.getParent();
        for (CTNode node : nodes) {
            if (node == head || node.c2d.hasHead()) continue;
            node.c2d.setHead(head, this.getDEPLabel(node, parent, head));
        }
        return head;
    }

    private int getHeadFlag(CTNode child) {
        if (child.c2d.hasHead()) {
            return -1;
        }
        if (this.hasAdverbialTag(child)) {
            return 1;
        }
        if (this.isMeta(child)) {
            return 2;
        }
        if (child.isEmptyCategoryRec() || CTLibEn.isPunctuation(child)) {
            return 3;
        }
        return 0;
    }

    public String getDEPLabel(CTNode C, CTNode P, CTNode p) {
        String label;
        CTNode c = C.c2d.getPhraseHead();
        CTNode d = C.c2d.getDependencyHead();
        if (this.hasAdverbialTag(C)) {
            if (C.isPTagAny("S", "SBAR", "SINV")) {
                return "advcl";
            }
            if (C.isPTagAny("NML", "NP", "QP")) {
                return "npadvmod";
            }
        }
        if ((label = this.getSubjectLabel(C, d)) != null) {
            return label;
        }
        if (C.isPTag("UCP")) {
            c.addFTags(C.getFTags());
            return this.getDEPLabel(c, P, p);
        }
        if (P.isPTagAny("VP", "SINV", "SQ")) {
            if (this.isAcomp(C)) {
                return "acomp";
            }
            label = this.getObjectLabel(C);
            if (label != null) {
                return label;
            }
            if (this.isOprd(C)) {
                return "oprd";
            }
            if (this.isXcomp(C)) {
                return "xcomp";
            }
            if (this.isCcomp(C)) {
                return "ccomp";
            }
            label = this.getAuxLabel(C);
            if (label != null) {
                return label;
            }
        }
        if (P.isPTagAny("ADJP", "ADVP")) {
            if (this.isXcomp(C)) {
                return "xcomp";
            }
            if (this.isCcomp(C)) {
                return "ccomp";
            }
        }
        if (P.isPTagAny("NML", "NP", "WHNP")) {
            if (this.isNfmod(C)) {
                return this.isInfMod(C) ? "infmod" : "partmod";
            }
            if (this.isRcmod(C)) {
                return "rcmod";
            }
            if (this.isCcomp(C)) {
                return "ccomp";
            }
        }
        if (this.isPoss(C, P)) {
            return "poss";
        }
        label = this.getSimpleLabel(C);
        if (label != null) {
            return label;
        }
        if (P.isPTagAny("PP", "WHPP") && (p.getParent() == C.getParent() ? p.getSiblingId() < C.getSiblingId() : p.getFirstTerminal().getTerminalId() < C.getFirstTerminal().getTerminalId())) {
            return this.getPmodLabel(C);
        }
        if (C.isPTag("SBAR") || this.isXcomp(C) || P.isPTag("PP") && CTLibEn.isClause(C)) {
            return "advcl";
        }
        if (C.isPTagAny("S", "SINV", "SQ", "SBARQ")) {
            return "ccomp";
        }
        if (P.isPTag("QP")) {
            if (C.isPTagAny("CD")) {
                return "number";
            }
            return "quantmod";
        }
        if (P.isPTagAny("NML", "NP", "NX", "WHNP") || CTLibEn.isNoun(p)) {
            return this.getNmodLabel(C);
        }
        if (c != null) {
            label = this.getSimpleLabel(c);
            if (label != null) {
                return label;
            }
            if (d.isPTag("IN")) {
                return "prep";
            }
            if (CTLibEn.isAdverb(d)) {
                return "advmod";
            }
        }
        if (P.isPTagAny("ADJP", "ADVP", "PP") || CTLibEn.isAdjective(p) || CTLibEn.isAdverb(p)) {
            if (C.isPTagAny("NML", "NP", "QP") || CTLibEn.isNoun(C)) {
                return "npadvmod";
            }
            return "advmod";
        }
        return "dep";
    }

    private boolean hasAdverbialTag(CTNode node) {
        return node.hasFTag("ADV") || node.hasFTagAny(this.a_semTags);
    }

    private String getObjectLabel(CTNode node) {
        if (node.isPTagAny("NP", "NML")) {
            if (node.hasFTag("PRD")) {
                return "attr";
            }
            return "dobj";
        }
        return null;
    }

    private String getSubjectLabel(CTNode C, CTNode d) {
        if (C.hasFTag("SBJ")) {
            if (CTLibEn.isClause(C)) {
                return "csubj";
            }
            if (d.isPTag("EX")) {
                return "expl";
            }
            return "nsubj";
        }
        if (C.hasFTag("LGS")) {
            return "agent";
        }
        return null;
    }

    private String getSimpleLabel(CTNode C) {
        if (this.isAmod(C)) {
            return "amod";
        }
        if (C.isPTagAny("PP", "WHPP")) {
            return "prep";
        }
        if (CTLibEn.isCorrelativeConjunction(C)) {
            return "preconj";
        }
        if (CTLibEn.isConjunction(C)) {
            return "cc";
        }
        if (this.isPrt(C)) {
            return "prt";
        }
        String label = this.getSpecialLabel(C);
        if (label != null) {
            return label;
        }
        return null;
    }

    private String getSpecialLabel(CTNode C) {
        CTNode d = C.c2d.getDependencyHead();
        if (CTLibEn.isPunctuation(C) || CTLibEn.isPunctuation(d)) {
            return "punct";
        }
        if (this.isIntj(C) || this.isIntj(d)) {
            return "intj";
        }
        if (this.isMeta(C)) {
            return "meta";
        }
        if (this.isPrn(C)) {
            return "parataxis";
        }
        if (this.isAdv(C)) {
            return "advmod";
        }
        return null;
    }

    private String getAuxLabel(CTNode node) {
        CTNode vp;
        if (node.isPTagAny("MD", "TO")) {
            return "aux";
        }
        if (CTLibEn.isVerb(node) && (vp = node.getNextSibling("VP")) != null) {
            if (MPLibEn.isBe(node.form) || MPLibEn.isBecome(node.form) || MPLibEn.isGet(node.form)) {
                if (vp.containsTags("+VBN|VBD")) {
                    return "auxpass";
                }
                if (!vp.containsTags("+VB.*") && (vp = vp.getFirstChild("VP")) != null && vp.containsTags("+VBN|VBD")) {
                    return "auxpass";
                }
            }
            return "aux";
        }
        return null;
    }

    private String getNmodLabel(CTNode node) {
        if (node.isPTagAny("VBG", "VBN")) {
            return "amod";
        }
        if (node.isPTagAny("DT", "WDT", "WP")) {
            return "det";
        }
        if (node.isPTagAny("NML", "NP", "FW") || node.pTag.startsWith("NN")) {
            return "nn";
        }
        if (node.isPTagAny("CD", "QP")) {
            return "num";
        }
        if (node.isPTag("POS")) {
            return "possessive";
        }
        if (node.isPTag("PDT")) {
            return "predet";
        }
        return "nmod";
    }

    private String getPmodLabel(CTNode C) {
        if (C.isPTagAny("NP", "NML")) {
            return "pobj";
        }
        return "pcomp";
    }

    private boolean isAmod(CTNode node) {
        return node.isPTagAny("ADJP", "WHADJP") || CTLibEn.isAdjective(node);
    }

    private boolean isAdv(CTNode C) {
        if (C.isPTag("ADVP") || CTLibEn.isAdverb(C)) {
            CTNode P = C.getParent();
            int id = C.getSiblingId();
            return !P.isPTagAny("PP", "WHPP") || id + 1 != P.getChildrenSize() || !P.getChild(id - 1).isPTagAny("IN", "TO");
        }
        return false;
    }

    private boolean isIntj(CTNode node) {
        return node.isPTagAny("INTJ", "UH");
    }

    private boolean isMeta(CTNode node) {
        return node.isPTagAny("EDITED", "EMBED", "LST", "META", "CODE", "CAPTION", "CIT", "HEADING", "TITLE");
    }

    private boolean isPrn(CTNode node) {
        return node.isPTag("PRN");
    }

    private boolean isPrt(CTNode curr) {
        return curr.isPTagAny("PRT", "RP");
    }

    private boolean isAcomp(CTNode node) {
        return node.isPTag("ADJP");
    }

    private boolean isOprd(CTNode curr) {
        if (curr.hasFTag("oprd")) {
            return true;
        }
        if (curr.isPTag("S") && !curr.containsTags("VP") && curr.containsTags("-PRD")) {
            CTNode sbj = curr.getFirstChild("-SBJ");
            return sbj != null && sbj.isEmptyCategoryRec();
        }
        return false;
    }

    private boolean isPoss(CTNode curr, CTNode parent) {
        if (curr.isPTagAny("PRP$", "WP$")) {
            return true;
        }
        if (parent.isPTagAny("NML", "NP", "WHNP", "QP", "ADJP")) {
            return curr.containsTags("POS");
        }
        return false;
    }

    private boolean isXcomp(CTNode node) {
        CTNode s;
        if (node.isPTag("S")) {
            CTNode sbj = node.getFirstChild("-SBJ");
            if (node.containsTags("VP") && (sbj == null || sbj.isEmptyCategoryRec())) {
                return true;
            }
        } else if (node.hasFTag("rcmod") && (s = node.getFirstChild("S")) != null) {
            return this.isXcomp(s);
        }
        return false;
    }

    private boolean isCcomp(CTNode node) {
        if (node.isPTagAny("S", "SQ", "SINV", "SBARQ")) {
            return true;
        }
        if (node.isPTag("SBAR")) {
            CTNode comp = node.getFirstChild("-NONE-");
            if (comp != null && comp.isForm("0")) {
                return true;
            }
            comp = node.getFirstChild("+IN|DT");
            if (comp != null && (comp.form.equalsIgnoreCase("that") || comp.form.equalsIgnoreCase("if") || comp.form.equalsIgnoreCase("whether"))) {
                comp.c2d.setLabel("complm");
                return true;
            }
            if (node.hasFTag("rcmod") || node.containsTags("+WH.*")) {
                return true;
            }
        }
        return false;
    }

    private boolean isNfmod(CTNode curr) {
        return this.isXcomp(curr) || curr.isPTag("VP");
    }

    private boolean isInfMod(CTNode curr) {
        CTNode vp;
        CTNode cTNode = vp = curr.isPTag("VP") ? curr : curr.getFirstDescendant("VP");
        if (vp != null) {
            CTNode vc = vp.getFirstChild("VP");
            while (vc != null) {
                vp = vc;
                if (vp.getPrevSibling("TO") != null) {
                    return true;
                }
                vc = vp.getFirstChild("VP");
            }
            return vp.containsTags("TO");
        }
        return false;
    }

    private boolean isRcmod(CTNode curr) {
        return curr.isPTag("RRC") || curr.hasFTag("rcmod") || curr.isPTag("SBAR") && curr.containsTags("+WH.*");
    }

    private DEPTree getDEPTree(CTTree cTree) {
        DEPTree dTree = this.initDEPTree(cTree);
        this.addDEPHeads(dTree, cTree);
        if (dTree.containsCycle()) {
            System.err.println("Error: cyclic dependencies exist");
        }
        this.splitLabels(dTree);
        this.addXHeads(dTree);
        this.addFeats(dTree, cTree, cTree.getRoot());
        this.addPBArgs(dTree, cTree);
        this.mergeLabels(dTree);
        return dTree;
    }

    private void mergeLabels(DEPTree dTree) {
        int size = dTree.size();
        for (Pair<String, Set<String>> p : this.l_mergeLabels) {
            for (int i = 1; i < size; ++i) {
                DEPNode node = dTree.get(i);
                if (!((Set)p.o2).contains(node.getLabel())) continue;
                node.setLabel((String)p.o1);
            }
        }
    }

    private DEPTree initDEPTree(CTTree cTree) {
        DEPTree dTree = new DEPTree();
        for (CTNode node : cTree.getTokens()) {
            int id = node.getTokenId() + 1;
            String form = MPLib.revertBracket(node.form);
            String lemma = "_";
            String pos = node.pTag;
            DEPNode dNode = new DEPNode(id, form, lemma, pos, node.c2d.d_feats);
            dTree.add(dNode);
        }
        dTree.initXHeads();
        return dTree;
    }

    private void addDEPHeads(DEPTree dTree, CTTree cTree) {
        int size = dTree.size();
        int rootCount = 0;
        for (int currId = 1; currId < size; ++currId) {
            DEPNode dNode = dTree.get(currId);
            CTNode cNode = cTree.getToken(currId - 1);
            int headId = cNode.c2d.d_head.getTokenId() + 1;
            if (currId == headId) {
                dNode.setHead(dTree.get(0), "root");
                ++rootCount;
            } else {
                String label = cNode.c2d.s_label;
                if (cNode.isPTagAny("IN", "TO", "DT") && cNode.getParent().isPTag("SBAR") && !label.equals("complm")) {
                    label = "mark";
                }
                dNode.setHead(dTree.get(headId), label);
            }
            CTNode ante = cNode.getAntecedent();
            if (ante == null) continue;
            dNode.addXHead(this.getDEPNode(dTree, ante), "ref");
        }
        if (rootCount > 1) {
            System.err.println("Warning: multiple roots exist");
        }
    }

    private void splitLabels(DEPTree tree) {
        int size = tree.size();
        tree.setDependents();
        for (int i = 1; i < size; ++i) {
            List<DEPNode> list;
            String lower;
            DEPNode node = tree.get(i);
            if (node.isLabel("advmod") && ((lower = node.form.toLowerCase()).equals("never") || lower.equals("not") || lower.equals("n't") || lower.equals("'nt") || lower.equals("no"))) {
                node.setLabel("neg");
            }
            if (node.containsDependent("auxpass")) {
                for (DEPNode child : node.getDependentsByLabels("csubj", "nsubj")) {
                    child.setLabel(child.getLabel() + "pass");
                }
            }
            if ((list = node.getDependentsByLabels("dobj")).size() <= 1) continue;
            list.get(0).setLabel("iobj");
        }
    }

    private void addXHeads(DEPTree dTree) {
        for (CTNode curr : this.m_xsbj.keySet()) {
            if (curr.c2d == null) continue;
            this.addXHeadsAux(dTree, curr, this.m_xsbj.get(curr), "xsubj");
        }
        for (CTNode curr : this.m_rnr.keySet()) {
            if (curr.getParent() == null) continue;
            if (curr.getParent().c2d.getPhraseHead() != curr) {
                this.addXHeadsAux(dTree, curr, this.m_rnr.get(curr), "rnr");
                continue;
            }
            this.addXChildren(dTree, curr, this.m_rnr.get(curr), "rnr");
        }
    }

    private void addXHeadsAux(DEPTree dTree, CTNode cNode, Deque<CTNode> dq, String label) {
        DEPNode node = this.getDEPNode(dTree, cNode);
        for (CTNode cHead : dq) {
            DEPNode head = this.getDEPNode(dTree, cHead);
            node.addXHead(head, label);
            if (!label.equals("xsubj") || !head.isLabel("ccomp")) continue;
            head.setLabel("xcomp");
        }
    }

    private void addXChildren(DEPTree dTree, CTNode cHead, Deque<CTNode> dq, String label) {
        DEPNode head = this.getDEPNode(dTree, cHead);
        for (CTNode cNode : dq) {
            DEPNode node = this.getDEPNode(dTree, cNode);
            node.addXHead(head, label);
        }
    }

    private void addFeats(DEPTree dTree, CTTree cTree, CTNode cNode) {
        String feat;
        CTNode ante;
        if (cNode.gapIndex != -1 && cNode.getParent().gapIndex == -1 && (ante = cTree.getCoIndexedAntecedent(cNode.gapIndex)) != null) {
            DEPNode dNode = this.getDEPNode(dTree, cNode);
            dNode.addXHead(this.getDEPNode(dTree, ante), "gap");
        }
        if ((feat = this.getFunctionTags(cNode, this.s_semTags)) != null) {
            cNode.c2d.putFeat("sem", feat);
        }
        if ((feat = this.getFunctionTags(cNode, this.s_synTags)) != null) {
            cNode.c2d.putFeat("syn", feat);
        }
        for (CTNode child : cNode.getChildren()) {
            this.addFeats(dTree, cTree, child);
        }
    }

    private String getFunctionTags(CTNode node, Set<String> sTags) {
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : node.getFTags()) {
            if (!sTags.contains(tag)) continue;
            tags.add(tag);
        }
        if (tags.isEmpty()) {
            return null;
        }
        Collections.sort(tags);
        StringBuilder build = new StringBuilder();
        for (String tag : tags) {
            build.append(",");
            build.append(tag);
        }
        return build.substring(",".length());
    }

    private void addPBArgs(DEPTree dTree, CTTree cTree) {
        CTNode root = cTree.getRoot();
        dTree.initSHeads();
        if (root.pbArgs != null) {
            this.initPBArgs(dTree, cTree, root);
            this.arrangePBArgs(dTree);
            this.relabelArgNs(dTree);
        }
    }

    private void initPBArgs(DEPTree dTree, CTTree cTree, CTNode cNode) {
        if (!cNode.isPTag("TOP")) {
            DEPNode dNode = cNode.isPhrase() ? this.getDEPNode(dTree, cNode) : dTree.get(cNode.getTokenId() + 1);
            for (StringIntPair p : cNode.pbArgs) {
                DEPNode sHead = dTree.get(p.i);
                if (cNode.pTag.startsWith("WH")) {
                    p.s = "R-" + p.s;
                }
                if (dNode.containsSHead(sHead) || dNode == sHead) continue;
                dNode.addSHead(sHead, p.s);
            }
        }
        for (CTNode child : cNode.getChildren()) {
            this.initPBArgs(dTree, cTree, child);
        }
    }

    private void arrangePBArgs(DEPTree dTree) {
        int size = dTree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = dTree.get(i);
            ArrayList<DEPArc> remove = new ArrayList<DEPArc>();
            for (DEPArc arc : node.getSHeads()) {
                String label;
                DEPNode head = arc.getNode();
                if (!this.ancestorHasSHead(node, head, label = arc.getLabel())) continue;
                remove.add(arc);
            }
            node.removeSHeads(remove);
        }
    }

    private boolean ancestorHasSHead(DEPNode dNode, DEPNode sHead, String label) {
        for (DEPNode dHead = dNode.getHead(); dHead != null; dHead = dHead.getHead()) {
            if (!dHead.isArgumentOf(sHead, label)) continue;
            return true;
        }
        return false;
    }

    protected boolean rnrHasSHead(DEPNode dNode, DEPNode sHead, String label) {
        for (DEPArc rnr : dNode.getXHeads("rnr")) {
            if (!rnr.getNode().isArgumentOf(sHead, label)) continue;
            return true;
        }
        return false;
    }

    private void relabelArgNs(DEPTree dTree) {
        HashMap<String, DEPNode> map = new HashMap<String, DEPNode>();
        int size = dTree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = dTree.get(i);
            ArrayList<DEPArc> remove = new ArrayList<DEPArc>();
            for (DEPArc arc : node.getSHeads()) {
                if (arc.getLabel().startsWith("R-") || arc.getLabel().startsWith("AM")) continue;
                String key = arc.toString();
                if (map.containsKey(key)) {
                    arc.setLabel("C-" + arc.getLabel());
                    continue;
                }
                map.put(key, node);
            }
            node.removeSHeads(remove);
        }
    }

    private DEPNode getDEPNode(DEPTree dTree, CTNode cNode) {
        return dTree.get(cNode.c2d.getDependencyHead().getTokenId() + 1);
    }
}

