/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import cc.mallet.classify.Classifier;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.jar.ClassifierBuilder_ImplBase;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.mallet.InstanceListCreator;
import org.cleartk.ml.mallet.MalletClassifier_ImplBase;
import org.cleartk.ml.mallet.factory.ClassifierTrainerFactory;
import org.cleartk.util.ReflectionUtil;

public abstract class MalletClassifierBuilder_ImplBase<CLASSIFIER_TYPE extends MalletClassifier_ImplBase<OUTCOME_TYPE>, OUTCOME_TYPE>
extends ClassifierBuilder_ImplBase<CLASSIFIER_TYPE, List<NameNumber>, OUTCOME_TYPE, String> {
    private static final String MODEL_NAME = "model.mallet";
    protected Classifier classifier;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.mallet");
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        InstanceListCreator instanceListCreator = new InstanceListCreator();
        InstanceList instanceList = instanceListCreator.createInstanceList(this.getTrainingDataFile(dir));
        instanceList.save(new File(dir, "training-data.ser"));
        String factoryName = args[0];
        Class<ClassifierTrainerFactory<?>> factoryClass = this.createTrainerFactory(factoryName);
        if (factoryClass == null) {
            String factoryName2 = "org.cleartk.ml.mallet.factory." + factoryName + "TrainerFactory";
            factoryClass = this.createTrainerFactory(factoryName2);
        }
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("name for classifier trainer factory is not valid: name given ='%s'.  Valid classifier names include: %s, %s, %s, and %s", factoryName, ClassifierTrainerFactory.NAMES[0], ClassifierTrainerFactory.NAMES[1], ClassifierTrainerFactory.NAMES[2], ClassifierTrainerFactory.NAMES[3]));
        }
        String[] factoryArgs = new String[args.length - 1];
        System.arraycopy(args, 1, factoryArgs, 0, factoryArgs.length);
        ClassifierTrainerFactory<?> factory = factoryClass.newInstance();
        ClassifierTrainer<?> trainer = null;
        try {
            trainer = factory.createTrainer(factoryArgs);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unable to create trainer.  Usage for " + factoryClass.getCanonicalName() + ": " + factory.getUsageMessage(), t);
        }
        this.classifier = trainer.train(instanceList);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(dir, MODEL_NAME)));
        oos.writeObject(this.classifier);
        oos.close();
    }

    private Class<ClassifierTrainerFactory<?>> createTrainerFactory(String className) {
        try {
            return (Class)ReflectionUtil.uncheckedCast(Class.forName(className));
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)MODEL_NAME, (File)new File(dir, MODEL_NAME));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)MODEL_NAME);
        ObjectInputStream objectStream = new ObjectInputStream(modelStream);
        try {
            this.classifier = (Classifier)objectStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

