/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntOpenHashSet
extends AbstractIntCollection
implements IntLookupContainer,
IntSet,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public int[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public IntOpenHashSet() {
        this(16, 0.75f);
    }

    public IntOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public IntOpenHashSet(IntContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(int e) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = e;
        return true;
    }

    public int add(int e1, int e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(int ... elements) {
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(IntContainer container) {
        return this.addAll((Iterable<? extends IntCursor>)container);
    }

    public final int addAll(Iterable<? extends IntCursor> iterable) {
        int count = 0;
        for (IntCursor intCursor : iterable) {
            if (!this.add(intCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        int[] oldKeys = this.keys;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            int key = oldKeys[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new int[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(int key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, 0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            IntSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntSet && (other = (IntSet)obj).size() == this.size()) {
                for (IntCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public final int[] toArray() {
        int[] cloned = new int[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public IntOpenHashSet clone() {
        try {
            IntOpenHashSet cloned = (IntOpenHashSet)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static IntOpenHashSet from(int ... elements) {
        IntOpenHashSet set = new IntOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static IntOpenHashSet from(IntContainer container) {
        return new IntOpenHashSet(container);
    }

    public static IntOpenHashSet newInstance() {
        return new IntOpenHashSet();
    }

    public static IntOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new IntOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = IntOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < IntOpenHashSet.this.keys.length && !IntOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

