/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank.util;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.corpus.propbank.util.PropbankCorefRelation;
import org.cleartk.corpus.propbank.util.PropbankFormatException;
import org.cleartk.corpus.propbank.util.PropbankRelation;
import org.cleartk.srl.type.SemanticArgument;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.util.AnnotationUtil;

@Beta
public class Proplabel {
    protected PropbankRelation relation = null;
    protected String label = null;
    protected String feature = null;
    protected String preposition = null;
    protected String hyphenTag;
    protected String propTxt;
    private static final Set<String> labels = new HashSet<String>(Arrays.asList("rel|Support|ARG0|ARG1|ARG2|ARG3|ARG4|ARG5|ARGA|ARGM".split("\\|")));
    private static final Set<String> labelsRequiringFeatures = new HashSet<String>(Arrays.asList("ARGM"));
    private static final Set<String> features = new HashSet<String>(Arrays.asList("ADV|CAU|DIR|DIS|EXT|LOC|MNR|MOD|NEG|PNC|PRD|REC|TMP".split("\\|")));
    private static final Set<String> hyphenTags = new HashSet<String>(Arrays.asList("H0|H1|H2|H3|H4|H5|H6|H7|H8|H9|XX".split("\\|")));

    static Proplabel fromString(String lblTxt) {
        String[] columns = lblTxt.split("-");
        if (columns.length < 1) {
            throw new PropbankFormatException(String.format("Missing label: %s", lblTxt));
        }
        if (!labels.contains(columns[1])) {
            throw new PropbankFormatException(String.format("Invalid label: %s", columns[1]));
        }
        Proplabel proplabel = new Proplabel();
        proplabel.setPropTxt(lblTxt);
        proplabel.setRelation(PropbankRelation.fromString(columns[0]));
        proplabel.setLabel(columns[1]);
        int expectedLength = 2;
        if (columns.length > 2) {
            if (features.contains(columns[2])) {
                proplabel.setFeature(columns[2]);
                if (columns.length > 3) {
                    if (hyphenTags.contains(columns[3])) {
                        proplabel.setHyphenTag(columns[3]);
                    }
                    expectedLength = 4;
                } else {
                    expectedLength = 3;
                }
            } else if (hyphenTags.contains(columns[2])) {
                proplabel.setHyphenTag(columns[2]);
                expectedLength = 3;
            } else {
                proplabel.setPreposition(columns[2]);
                expectedLength = 3;
            }
        }
        if (columns.length != expectedLength) {
            throw new PropbankFormatException(String.format("Expected %d items, found %d", expectedLength, columns.length));
        }
        if (labelsRequiringFeatures.contains(columns[1]) && proplabel.getFeature() == null) {
            throw new PropbankFormatException(String.format("Label %s requires a feature", proplabel.getLabel()));
        }
        return proplabel;
    }

    protected Proplabel() {
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public void setPreposition(String preposition) {
        this.preposition = preposition;
    }

    public String getHyphenTag() {
        return this.hyphenTag;
    }

    public void setHyphenTag(String hyphenTag) {
        this.hyphenTag = hyphenTag;
    }

    public PropbankRelation getRelation() {
        return this.relation;
    }

    public void setRelation(PropbankRelation relation) {
        this.relation = relation;
    }

    public String getPropTxt() {
        return this.propTxt;
    }

    public void setPropTxt(String propTxt) {
        this.propTxt = propTxt;
    }

    public SemanticArgument convert(JCas view, TopTreebankNode topNode) {
        SemanticArgument argument = new SemanticArgument(view);
        argument.setPropTxt(this.propTxt);
        argument.setLabel(this.label);
        argument.setFeature(this.feature);
        argument.setPreposition(this.preposition);
        argument.setHyphenTag(this.hyphenTag);
        if (this.relation instanceof PropbankCorefRelation) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            ArrayList<Annotation> substantiveAnnotations = new ArrayList<Annotation>();
            for (PropbankRelation rel : ((PropbankCorefRelation)this.relation).getCorefRelations()) {
                Annotation a = rel.convert(view, topNode);
                annotations.add(a);
                if (a.getBegin() == a.getEnd()) continue;
                substantiveAnnotations.add(a);
            }
            argument.setCoreferenceAnnotations(new FSArray(view, annotations.size()));
            FSCollectionFactory.fillArrayFS((ArrayFS)argument.getCoreferenceAnnotations(), annotations);
            if (substantiveAnnotations.isEmpty()) {
                Annotation lastAnnotation = (Annotation)annotations.get(annotations.size() - 1);
                argument.setBegin(lastAnnotation.getBegin());
                argument.setEnd(lastAnnotation.getEnd());
            } else {
                int[] extent = AnnotationUtil.getAnnotationsExtent(substantiveAnnotations);
                argument.setBegin(extent[0]);
                argument.setEnd(extent[1]);
            }
            if (substantiveAnnotations.size() == 1) {
                argument.setAnnotation((Annotation)substantiveAnnotations.get(0));
            }
        } else {
            argument.setAnnotation(this.relation.convert(view, topNode));
            argument.setBegin(argument.getAnnotation().getBegin());
            argument.setEnd(argument.getAnnotation().getEnd());
        }
        argument.addToIndexes();
        return argument;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRelation().toString());
        buffer.append("-" + this.getLabel());
        if (this.getFeature() != null) {
            buffer.append("-" + this.getFeature());
        }
        if (this.getHyphenTag() != null) {
            buffer.append("-" + this.getHyphenTag());
        }
        if (this.getPreposition() != null) {
            buffer.append("-" + this.getPreposition());
        }
        return buffer.toString();
    }
}

