/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.train;

import java.util.ArrayList;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.util.AssertionConst;

public class CrossValidateChi2GridSearch {
    public static void main(String[] args) throws Exception {
        float[] threshs;
        AssertionEvaluation.useEvaluationLogFile = true;
        float[] fArray = threshs = new float[]{1.0f, 5.0f, 10.0f, 50.0f, 100.0f};
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float chi2threshold = Float.valueOf(fArray[i]);
            System.out.println("BEGIN Chi2 Grid Search with threshold = " + Float.toString(chi2threshold.floatValue()));
            for (String attribute : AssertionConst.annotationTypes) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("--train-dir");
                params.add(AssertionConst.trainingDirectories.get(attribute));
                params.add("--models-dir");
                params.add(AssertionConst.modelDirectory + Float.toString(chi2threshold.floatValue()));
                params.add("--cross-validation");
                params.add("5");
                params.add("--feature-selection");
                params.add(Float.toString(chi2threshold.floatValue()));
                for (String ignoreAttribute : AssertionConst.annotationTypes) {
                    if (ignoreAttribute.equals(attribute)) continue;
                    if (ignoreAttribute.equals("historyOf")) {
                        ignoreAttribute = ignoreAttribute.substring(0, ignoreAttribute.length() - 2);
                    }
                    params.add("--ignore-" + ignoreAttribute);
                }
                String[] paramList = params.toArray(new String[0]);
                AssertionEvaluation.main(paramList);
            }
        }
    }
}

