/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AboveLeftFragmentExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AssertionAboveLeftTreeExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AssertionDependencyTreeExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ContextWordWindowExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.NegationDependencyFeatureExtractor;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

@PipeBitInfo(name="Negation Annotator (ClearTK)", description="Annotates negation property.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class PolarityCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    public static final String NEGATED = "NEGATED";
    public static final String NOT_NEGATED = "NOT_NEGATED";

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 1.0;
        if (this.entityFeatureExtractors == null) {
            this.entityFeatureExtractors = new ArrayList();
        }
        if (this.featConfig != AssertionCleartkAnalysisEngine.FEATURE_CONFIG.NO_SEM) {
            this.entityFeatureExtractors.add(new ContextWordWindowExtractor("org/apache/ctakes/assertion/models/polarity.txt"));
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.STK_FRAGS || this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN) {
            this.entityFeatureExtractors.add(new AboveLeftFragmentExtractor("AL_Polarity", "org/apache/ctakes/assertion/models/sharpPolarityFrags.txt"));
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.PTK_FRAGS || this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.DEP_REGEX_FRAGS || this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN) {
            // empty if block
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.DEP_REGEX || this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.DEP_REGEX_FRAGS || this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN) {
            this.entityFeatureExtractors.add(new NegationDependencyFeatureExtractor());
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.STK) {
            this.entityTreeExtractors.add(new AssertionAboveLeftTreeExtractor());
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.PTK) {
            this.entityTreeExtractors.add(new AssertionDependencyTreeExtractor());
        }
        this.initializeFeatureSelection();
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            String polarity;
            this.lastLabel = polarity = entityOrEventMention.getPolarity() == -1 ? NEGATED : NOT_NEGATED;
            if (NEGATED.equals(polarity)) {
                this.logger.debug((Object)("TRAINING: " + polarity));
            }
            if (NOT_NEGATED.equals(polarity) && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)polarity);
        } else {
            String label;
            this.lastLabel = label = (String)this.classifier.classify(instance.getFeatures());
            int polarity = 1;
            if (NOT_NEGATED.equals(label)) {
                polarity = 1;
            } else if (NEGATED.equals(label)) {
                polarity = -1;
                this.logger.debug((Object)String.format("DECODING/EVAL: %s//%s [%d-%d] (%s)", label, polarity, entityOrEventMention.getBegin(), entityOrEventMention.getEnd(), entityOrEventMention.getClass().getName()));
            }
            entityOrEventMention.setPolarity(polarity);
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : PolarityCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(PolarityCleartkAnalysisEngine.class, (Object[])new Object[]{"FEATURE_CONFIG", AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return PolarityCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/polarity/sharpi2b2mipacqnegex/model.jar");
    }
}

