/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.assertion.attributes.features.HistoryFeaturesExtractor;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ContextWordWindowExtractor;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

@PipeBitInfo(name="History of ClearTK Annotator", description="Annotate History of property.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class HistoryCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    boolean USE_DEFAULT_EXTRACTORS = false;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 0.5;
        this.initialize_history_extractor();
        this.initializeFeatureSelection();
    }

    private void initialize_history_extractor() {
        if (this.entityFeatureExtractors == null) {
            this.entityFeatureExtractors = new ArrayList();
        }
        this.entityFeatureExtractors.add(new ContextWordWindowExtractor("org/apache/ctakes/assertion/models/history.txt"));
        this.entityFeatureExtractors.add(new HistoryFeaturesExtractor());
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            int history = entityOrEventMention.getHistoryOf();
            if (history == 0 && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)String.valueOf(history));
        } else {
            String label = (String)this.classifier.classify(instance.getFeatures());
            entityOrEventMention.setHistoryOf(Integer.parseInt(label));
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : HistoryCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(HistoryCleartkAnalysisEngine.class, (Object[])new Object[]{"classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return HistoryCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/historyOf/model.jar");
    }
}

