/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import org.apache.ctakes.assertion.medfacts.ConceptLookup;
import org.apache.ctakes.assertion.medfacts.types.Concept;
import org.apache.ctakes.assertion.stub.ConceptType;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

@PipeBitInfo(name="Concept Converter", description="Creates a simple Concept for each Identified Annotation.", dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class ConceptConverterAnalysisEngine
extends JCasAnnotator_ImplBase {
    public static final Logger logger = Logger.getLogger((String)ConceptConverterAnalysisEngine.class.getName());

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        logger.info((Object)"beginning of ConceptConverterAnalysisEngine.process()");
        String contents = jcas.getDocumentText();
        this.processForEntityType(jcas, EntityMention.type, EntityMention.class);
        this.processForEntityType(jcas, EventMention.type, EventMention.class);
        logger.info((Object)"end of ConceptConverterAnalysisEngine.process()");
    }

    public void processForEntityType(JCas jcas, int annotationType, Class<? extends IdentifiedAnnotation> annotationClass) {
        AnnotationIndex annotationIndex = jcas.getAnnotationIndex(annotationType);
        int totalAnnotationCount = jcas.getAnnotationIndex().size();
        int typeSpecificAnnotationCount = annotationIndex.size();
        logger.info((Object)String.format("    total annotation count %d", totalAnnotationCount));
        logger.info((Object)String.format("    %s annotation count %d", annotationClass.getName(), typeSpecificAnnotationCount));
        for (FeatureStructure featureStructure : annotationIndex) {
            IdentifiedAnnotation annotation = (IdentifiedAnnotation)featureStructure;
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            String conceptText = annotation.getCoveredText();
            Concept concept = new Concept(jcas, begin, end);
            concept.setConceptText(conceptText);
            concept.setConceptType(null);
            concept.setOriginalEntityExternalId(annotation.getAddress());
            FSArray ontologyConceptArray = annotation.getOntologyConceptArr();
            ConceptType conceptType = ConceptLookup.lookupConceptType(ontologyConceptArray);
            if (conceptType != null) {
                concept.setConceptType(conceptType.toString());
            }
            concept.addToIndexes();
        }
    }
}

