/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.assertion.medfacts.CasIndexer;
import org.apache.ctakes.assertion.medfacts.i2b2.api.CharacterOffsetToLineTokenConverterCtakesImpl;
import org.apache.ctakes.assertion.medfacts.i2b2.api.SingleDocumentProcessorCtakes;
import org.apache.ctakes.assertion.medfacts.types.Concept;
import org.apache.ctakes.assertion.stub.ApiConcept;
import org.apache.ctakes.assertion.stub.AssertionDecoderConfiguration;
import org.apache.ctakes.assertion.stub.BatchRunner;
import org.apache.ctakes.assertion.stub.JarafeMEDecoder;
import org.apache.ctakes.assertion.stub.PartOfSpeechTagger;
import org.apache.ctakes.assertion.stub.ScopeParser;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Assertion Engine (FIT)", description="Adds Negation, Uncertainty, Conditional and Subject to annotations.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class AssertionAnalysisEngineFit
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AssertionAnalysisEngineFit");
    public static final String ASSERTION_MODEL_PARAM = "assertionModelResource";
    public static final String SCOPE_MODEL_PARAM = "scopeModelResource";
    public static final String CUE_MODEL_PARAM = "cueModelResource";
    public static final String POS_MODEL_PARAM = "posModelResource";
    public static final String ENABLED_FEATURES_PARAM = "enabledFeaturesResource";
    @ConfigurationParameter(name="assertionModelResource", defaultValue={"org/apache/ctakes/assertion/models/i2b2.model"})
    private String _assertionModelPath;
    @ConfigurationParameter(name="scopeModelResource", defaultValue={"org/apache/ctakes/assertion/models/scope.model"})
    private String _scopeModelPath;
    @ConfigurationParameter(name="cueModelResource", defaultValue={"org/apache/ctakes/assertion/models/cue.model"})
    private String _cueModelPath;
    @ConfigurationParameter(name="posModelResource", defaultValue={"org/apache/ctakes/assertion/models/pos.model"})
    private String _posModelPath;
    @ConfigurationParameter(name="enabledFeaturesResource", defaultValue={"org/apache/ctakes/assertion/models/featureFile11b"})
    private String _enabledFeaturesPath;
    private AssertionDecoderConfiguration _assertionDecoderConfiguration;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        File enabledFeaturesFile;
        String posModelFilePath;
        String cueModelFilePath;
        String scopeModelFilePath;
        File assertionModelFile;
        super.initialize(uimaContext);
        try {
            assertionModelFile = FileLocator.locateFile((String)this._assertionModelPath);
            scopeModelFilePath = FileLocator.getFullPath((String)this._scopeModelPath);
            cueModelFilePath = FileLocator.getFullPath((String)this._cueModelPath);
            posModelFilePath = FileLocator.getFullPath((String)this._posModelPath);
            enabledFeaturesFile = FileLocator.locateFile((String)this._enabledFeaturesPath);
        }
        catch (FileNotFoundException fnfE) {
            throw new ResourceInitializationException((Throwable)fnfE);
        }
        LOGGER.info((Object)("scope model file: " + scopeModelFilePath));
        LOGGER.info((Object)("cue model file: " + cueModelFilePath));
        LOGGER.info((Object)("pos model file: " + posModelFilePath));
        AssertionDecoderConfiguration assertionDecoderConfiguration = new AssertionDecoderConfiguration();
        ScopeParser scopeParser = new ScopeParser(scopeModelFilePath, cueModelFilePath);
        assertionDecoderConfiguration.setScopeParser(scopeParser);
        PartOfSpeechTagger posTagger = new PartOfSpeechTagger(posModelFilePath);
        assertionDecoderConfiguration.setPosTagger(posTagger);
        Set<String> enabledFeatureIdSet = BatchRunner.loadEnabledFeaturesFromFile(enabledFeaturesFile);
        assertionDecoderConfiguration.setEnabledFeatureIdSet(enabledFeatureIdSet);
        JarafeMEDecoder assertionDecoder = new JarafeMEDecoder(assertionModelFile);
        assertionDecoderConfiguration.setAssertionDecoder(assertionDecoder);
        this._assertionDecoderConfiguration = assertionDecoderConfiguration;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Starting processing");
        String documentText = jcas.getDocumentText();
        ArrayList<ApiConcept> apiConceptList = new ArrayList<ApiConcept>();
        Collection concepts = JCasUtil.select((JCas)jcas, Concept.class);
        for (Concept concept : concepts) {
            int begin = concept.getBegin();
            int end = concept.getEnd();
            String conceptText = documentText.substring(begin, end);
            ApiConcept apiConcept = new ApiConcept();
            apiConcept.setBegin(begin);
            apiConcept.setEnd(end);
            apiConcept.setText(conceptText);
            apiConcept.setType(concept.getConceptType());
            apiConcept.setExternalId(concept.getAddress());
            apiConceptList.add(apiConcept);
        }
        SingleDocumentProcessorCtakes processor = new SingleDocumentProcessorCtakes();
        processor.setJcas(jcas);
        processor.setAssertionDecoderConfiguration(this._assertionDecoderConfiguration);
        processor.setContents(documentText);
        CharacterOffsetToLineTokenConverterCtakesImpl converter = new CharacterOffsetToLineTokenConverterCtakesImpl(jcas);
        processor.setConverter2(converter);
        apiConceptList.forEach(processor::addConcept);
        LOGGER.debug((Object)"BEFORE CALLING processor.processSingleDocument()");
        processor.processSingleDocument();
        LOGGER.debug((Object)"AFTER CALLING processor.processSingleDocument()");
        Map<Integer, String> assertionTypeMap = processor.getAssertionTypeMap();
        CasIndexer indexer = new CasIndexer(jcas, null);
        for (Map.Entry<Integer, String> current : assertionTypeMap.entrySet()) {
            Integer currentIndex = current.getKey();
            String currentAssertionType = current.getValue();
            ApiConcept originalConcept = (ApiConcept)apiConceptList.get(currentIndex);
            Concept associatedConcept = (Concept)indexer.lookupByAddress(originalConcept.getExternalId());
            int entityAddress = associatedConcept.getOriginalEntityExternalId();
            IdentifiedAnnotation annotation = (IdentifiedAnnotation)indexer.lookupByAddress(entityAddress);
            AssertionAnalysisEngineFit.mapI2B2AssertionValueToCtakes(currentAssertionType, annotation);
        }
        LOGGER.info((Object)"Processing Finished");
    }

    private static void fillProperties(IdentifiedAnnotation annotation, int polarity, int uncertainty, boolean generic, boolean conditional, String subject, float confidence) {
        annotation.setPolarity(polarity);
        annotation.setUncertainty(uncertainty);
        annotation.setGeneric(generic);
        annotation.setConditional(conditional);
        annotation.setSubject(subject);
        annotation.setConfidence(confidence);
    }

    private static void mapI2B2AssertionValueToCtakes(String assertionType, IdentifiedAnnotation annotation) throws AnalysisEngineProcessException {
        if (assertionType == null) {
            LOGGER.error((Object)"current assertion type is null");
            AssertionAnalysisEngineFit.fillProperties(annotation, -2, -2, false, false, "skipped", -2.0f);
            return;
        }
        switch (assertionType) {
            case "present": {
                AssertionAnalysisEngineFit.fillProperties(annotation, 1, 0, false, false, "patient", 1.0f);
                break;
            }
            case "absent": {
                AssertionAnalysisEngineFit.fillProperties(annotation, -1, 0, false, false, "patient", 1.0f);
                break;
            }
            case "associated_with_someone_else": {
                AssertionAnalysisEngineFit.fillProperties(annotation, 1, 0, false, false, "family_member", 1.0f);
                break;
            }
            case "conditional": {
                AssertionAnalysisEngineFit.fillProperties(annotation, 1, 0, false, true, "patient", 1.0f);
                break;
            }
            case "hypothetical": {
                AssertionAnalysisEngineFit.fillProperties(annotation, 1, 0, true, false, "patient", 1.0f);
                break;
            }
            case "possible": {
                AssertionAnalysisEngineFit.fillProperties(annotation, 1, 1, false, false, "patient", 1.0f);
                break;
            }
            default: {
                LOGGER.error((Object)("unexpected assertion value returned: " + assertionType));
                AssertionAnalysisEngineFit.fillProperties(annotation, -2, -2, false, false, "skipped", -2.0f);
            }
        }
    }
}

