/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.internal.util.BrowserUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.docanalyzer.PrefsMediator;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.stylemap.ColorParser;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.util.gui.AboutDialog;
import org.apache.uima.tools.util.gui.Caption;
import org.apache.uima.tools.util.gui.FileSelector;
import org.apache.uima.tools.util.gui.SpringUtilities;
import org.apache.uima.tools.util.htmlview.AnnotationViewGenerator;
import org.apache.uima.tools.viewer.CasAnnotationViewer;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasToInlineXml;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.apache.uima.util.XmlCasDeserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DBAnnotationViewerMain
extends JFrame {
    private static final long serialVersionUID = -3201723535833938833L;
    private String strDescriptorFile = null;
    private CAS casDescriptor = null;
    private Properties jdbcProperties = null;
    File styleMapFile;
    protected AnnotationViewGenerator annotationViewGenerator = new AnnotationViewGenerator(this.createTempDir());
    private String defaultCasViewName = "_InitialView";
    private PrefsMediator prefsMed;
    private boolean processedStyleMap = false;
    JRadioButton javaViewerRB = null;
    JRadioButton javaViewerUCRB = null;
    JRadioButton htmlRB = null;
    JRadioButton xmlRB = null;
    JTextField documentIDField = null;
    private static final String HELP_MESSAGE = "Instructions for using Annotation Viewer:\n\n1) In the \"TypeSystem or AE Descriptor File\" field, either type or use the browse\nbutton to select the TypeSystem or AE descriptor for the AE that generated the\nXMI or XCAS files.  (This is needed for type system infornation only.\nAnalysis will not be redone.)\n\n2) Specify a Document ID.\n\n3) Click the \"View\" button at the buttom of the window.\n\n4) Select the view type -- either the Java annotation viewer, HTML,\nor XML.  The Java annotation viewer is recommended.\n\n";
    private File uimaHomeDir;
    private FileSelector taeDescriptorFileSelector;
    private JButton viewButton;
    private JDialog aboutDialog;
    private Preferences prefs = Preferences.userRoot().node("ytex/tools/DBAnnotationViewer");

    public DBAnnotationViewerMain() {
        super("Annotation Viewer");
        this.uimaHomeDir = new File(System.getProperty("uima.home", "C:/Program Files/apache-uima"));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        try {
            this.setIconImage(Images.getImage((String)"/org/apache/uima/tools/images/Micro_16.gif"));
        }
        catch (IOException e) {
            System.err.println("Image could not be loaded: " + e.getMessage());
        }
        this.getContentPane().setBackground(Color.WHITE);
        this.aboutDialog = new AboutDialog((JFrame)this, "About Annotation Viewer");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutMenuItem = new JMenuItem("About");
        JMenuItem helpMenuItem = new JMenuItem("Help");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        fileMenu.add(exitMenuItem);
        helpMenu.add(aboutMenuItem);
        helpMenu.add(helpMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        Caption labelStyleMapFile = new Caption("TypeSystem or AE Descriptor File: ");
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        controlPanel.setLayout(new SpringLayout());
        this.taeDescriptorFileSelector = new FileSelector("", "TAE Descriptor File", 0, this.uimaHomeDir);
        File descriptorFile = new File(this.uimaHomeDir, "examples/descriptors/analysis_engine/PersonTitleAnnotator.xml");
        this.taeDescriptorFileSelector.setSelected(descriptorFile.getAbsolutePath());
        Caption labelDocumentID = new Caption("Document ID:");
        this.documentIDField = new JTextField();
        controlPanel.add((Component)labelStyleMapFile);
        controlPanel.add((Component)this.taeDescriptorFileSelector);
        controlPanel.add((Component)labelDocumentID);
        controlPanel.add(this.documentIDField);
        Caption displayFormatLabel = new Caption("Results Display Format:");
        controlPanel.add((Component)displayFormatLabel);
        JPanel displayFormatPanel = new JPanel();
        displayFormatPanel.setLayout(new FlowLayout(0));
        displayFormatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.javaViewerRB = new JRadioButton("Java Viewer");
        this.javaViewerUCRB = new JRadioButton("JV user colors");
        this.htmlRB = new JRadioButton("HTML");
        this.xmlRB = new JRadioButton("XML");
        ButtonGroup displayFormatButtonGroup = new ButtonGroup();
        displayFormatButtonGroup.add(this.javaViewerRB);
        displayFormatButtonGroup.add(this.javaViewerUCRB);
        displayFormatButtonGroup.add(this.htmlRB);
        displayFormatButtonGroup.add(this.xmlRB);
        this.javaViewerRB.setSelected(true);
        displayFormatPanel.add(this.javaViewerRB);
        displayFormatPanel.add(this.javaViewerUCRB);
        displayFormatPanel.add(this.htmlRB);
        displayFormatPanel.add(this.xmlRB);
        controlPanel.add(displayFormatPanel);
        SpringUtilities.makeCompactGrid((Container)controlPanel, (int)3, (int)2, (int)4, (int)4, (int)4, (int)4);
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DBAnnotationViewerMain.this.savePreferences();
                System.exit(0);
            }
        });
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DBAnnotationViewerMain.this.aboutDialog.setVisible(true);
            }
        });
        helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(DBAnnotationViewerMain.this, DBAnnotationViewerMain.HELP_MESSAGE, "Annotation Viewer Help", -1);
            }
        });
        Container contentPanel = this.getContentPane();
        contentPanel.add((Component)controlPanel, "Center");
        JLabel banner = new JLabel(new ImageIcon(this.getClass().getResource("/org/apache/ctakes/ctakes_logo.jpg")));
        contentPanel.add((Component)banner, "North");
        this.viewButton = new JButton("View");
        JPanel lowerButtonsPanel = new JPanel();
        lowerButtonsPanel.add(this.viewButton);
        contentPanel.add((Component)lowerButtonsPanel, "South");
        this.setContentPane(contentPanel);
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ee) {
                try {
                    DBAnnotationViewerMain.this.viewDocuments();
                }
                catch (Exception e) {
                    DBAnnotationViewerMain.this.displayError(e);
                }
            }
        });
        if (System.getProperty("uima.noprefs") == null) {
            this.restorePreferences();
        }
    }

    public void viewDocuments() throws InvalidXMLException, IOException, ResourceInitializationException {
        String newDescriptorFile = this.taeDescriptorFileSelector.getSelected();
        if (!newDescriptorFile.equals(this.strDescriptorFile)) {
            this.strDescriptorFile = null;
            this.casDescriptor = null;
            this.styleMapFile = null;
            File descriptorFile = new File(newDescriptorFile);
            if (!descriptorFile.exists() || descriptorFile.isDirectory()) {
                this.displayError("Descriptor File \"" + descriptorFile.getPath() + "\" does not exist.");
                return;
            }
            XMLizable descriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(descriptorFile));
            if (descriptor instanceof AnalysisEngineDescription) {
                this.casDescriptor = CasCreationUtils.createCas((AnalysisEngineDescription)((AnalysisEngineDescription)descriptor));
                this.styleMapFile = this.getStyleMapFile((AnalysisEngineDescription)descriptor, descriptorFile.getPath());
            } else if (descriptor instanceof TypeSystemDescription) {
                TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
                tsDesc.resolveImports();
                this.casDescriptor = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
                this.styleMapFile = this.getStyleMapFile((TypeSystemDescription)descriptor, descriptorFile.getPath());
            } else {
                this.displayError("Invalid Descriptor File \"" + descriptorFile.getPath() + "\"" + "Must be either an AnalysisEngine or TypeSystem descriptor.");
                return;
            }
            this.strDescriptorFile = newDescriptorFile;
        }
        this.prefsMed = new PrefsMediator();
        this.prefsMed.setOutputDir(System.getProperty("user.home"));
        this.launchThatViewer(this.documentIDField.getText(), this.casDescriptor.getTypeSystem(), null, this.javaViewerRB.isSelected(), this.javaViewerUCRB.isSelected(), this.xmlRB.isSelected(), this.styleMapFile, this.createTempDir());
    }

    private File getStyleMapFile(AnalysisEngineDescription tad, String descFileName) throws IOException {
        File styleMapFile = this.getStyleMapFileName(descFileName);
        if (!styleMapFile.exists()) {
            String xml = AnnotationViewGenerator.autoGenerateStyleMap((AnalysisEngineMetaData)tad.getAnalysisEngineMetaData());
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(styleMapFile)));
            writer.println(xml);
            writer.close();
        }
        return styleMapFile;
    }

    private File getStyleMapFile(TypeSystemDescription tsd, String descFileName) throws IOException {
        File styleMapFile = this.getStyleMapFileName(descFileName);
        if (!styleMapFile.exists()) {
            String xml = AnnotationViewGenerator.autoGenerateStyleMap((TypeSystemDescription)tsd);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(styleMapFile)));
            writer.println(xml);
            writer.close();
        }
        return styleMapFile;
    }

    public File getStyleMapFileName(String aDescriptorFileName) {
        int index = aDescriptorFileName.lastIndexOf(".");
        String baseName = index > 0 ? aDescriptorFileName.substring(0, index) : aDescriptorFileName;
        return new File(baseName + "StyleMap.xml");
    }

    public static void main(String[] args) {
        final DBAnnotationViewerMain frame = new DBAnnotationViewerMain();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.savePreferences();
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void savePreferences() {
        this.prefs.put("taeDescriptorFile", this.taeDescriptorFileSelector.getSelected());
    }

    public void restorePreferences() {
        File defaultTaeDescriptorFile = new File(this.uimaHomeDir, "examples/descriptors/analysis_engine/PersonTitleAnnotator.xml");
        this.taeDescriptorFileSelector.setSelected(this.prefs.get("taeDescriptorFile", defaultTaeDescriptorFile.toString()));
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = ((UIMAException)aThrowable).getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = ((UIMARuntimeException)aThrowable).getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 270);
    }

    public void launchThatViewer(String documentID, TypeSystem typeSystem, String[] aTypesToDisplay, boolean javaViewerRBisSelected, boolean javaViewerUCRBisSelected, boolean xmlRBisSelected, File styleMapFile, File viewerDirectory) {
        try {
            CAS cas = this.loadDocumentCas(documentID, typeSystem);
            cas = cas.getView(this.defaultCasViewName);
            if (javaViewerRBisSelected || javaViewerUCRBisSelected) {
                this.prefsMed.setViewType(javaViewerRBisSelected ? "Java Viewer" : "JV User Colors");
                CasAnnotationViewer viewer = new CasAnnotationViewer();
                viewer.setDisplayedTypes(aTypesToDisplay);
                if (javaViewerUCRBisSelected) {
                    this.getColorsForTypesFromFile(viewer, styleMapFile);
                } else {
                    viewer.setHiddenTypes(new String[]{"uima.cpm.FileLocation"});
                }
                viewer.setCAS(cas);
                JDialog dialog = new JDialog((Frame)this, "Annotation Results for Document ID " + documentID);
                dialog.getContentPane().add((Component)viewer);
                dialog.setSize(850, 630);
                dialog.pack();
                dialog.show();
            } else {
                CAS defaultView = cas.getView("_InitialView");
                if (defaultView.getDocumentText() == null) {
                    this.displayError("The HTML and XML Viewers can only view the default text document, which was not found in this CAS.");
                    return;
                }
                File inlineXmlFile = new File(viewerDirectory, "inline.xml");
                String xmlAnnotations = new CasToInlineXml().generateXML(defaultView);
                FileOutputStream outStream = new FileOutputStream(inlineXmlFile);
                outStream.write(xmlAnnotations.getBytes("UTF-8"));
                outStream.close();
                if (xmlRBisSelected) {
                    this.prefsMed.setViewType("XML");
                    BrowserUtil.openUrlInDefaultBrowser((String)inlineXmlFile.getAbsolutePath());
                } else {
                    this.prefsMed.setViewType("HTML");
                    if (!this.processedStyleMap) {
                        if (!styleMapFile.exists()) {
                            this.annotationViewGenerator.autoGenerateStyleMapFile(this.promptForAE().getAnalysisEngineMetaData(), styleMapFile);
                        }
                        this.annotationViewGenerator.processStyleMap(styleMapFile);
                        this.processedStyleMap = true;
                    }
                    this.annotationViewGenerator.processDocument(inlineXmlFile);
                    File genFile = new File(viewerDirectory, "index.html");
                    BrowserUtil.openUrlInDefaultBrowser((String)genFile.getAbsolutePath());
                }
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    protected AnalysisEngineDescription promptForAE() throws IOException, InvalidXMLException, ResourceInitializationException {
        if (this.prefsMed.getTAEfile() != null) {
            File taeFile = new File(this.prefsMed.getTAEfile());
            XMLInputSource in = new XMLInputSource(taeFile);
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
            return aed;
        }
        String taeDir = this.prefsMed.getTAEfile();
        JFileChooser chooser = new JFileChooser(taeDir);
        chooser.setDialogTitle("Select the Analysis Engine that Generated this Output");
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            XMLInputSource in = new XMLInputSource(chooser.getSelectedFile());
            return UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
        }
        return null;
    }

    public void getColorsForTypesFromFile(CasAnnotationViewer viewer, File aStyleMapFile) {
        ArrayList<Color> colorList = new ArrayList<Color>();
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> notCheckedList = new ArrayList<String>();
        ArrayList<String> hiddenList = new ArrayList<String>();
        hiddenList.add("uima.cpm.FileLocation");
        if (aStyleMapFile.exists()) {
            FileInputStream stream = null;
            Document parse = null;
            try {
                stream = new FileInputStream(aStyleMapFile);
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parse = db.parse(stream);
            }
            catch (FileNotFoundException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (SAXException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            Element node0 = parse.getDocumentElement();
            NodeList nodeList = node0.getChildNodes();
            ColorParser cParser = new ColorParser();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("rule")) continue;
                NodeList childrenList = node.getChildNodes();
                String type = "";
                String label = "";
                StyleMapEntry sme = null;
                String colorText = "";
                for (int j = 0; j < childrenList.getLength(); ++j) {
                    Node child = childrenList.item(j);
                    String childName = child.getNodeName();
                    if (childName.equals("pattern")) {
                        type = DBAnnotationViewerMain.getTextValue(child);
                    }
                    if (childName.equals("label")) {
                        label = DBAnnotationViewerMain.getTextValue(child);
                    }
                    if (!childName.equals("style")) continue;
                    colorText = DBAnnotationViewerMain.getTextValue(child);
                }
                sme = cParser.parseAndAssignColors(type, label, label, colorText);
                if (!sme.getChecked()) {
                    notCheckedList.add(sme.getAnnotationTypeName());
                }
                if (!sme.getHidden()) {
                    colorList.add(sme.getBackground());
                    typeList.add(sme.getAnnotationTypeName());
                    continue;
                }
                hiddenList.add(sme.getAnnotationTypeName());
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            viewer.assignColorsFromList(colorList, typeList);
            viewer.assignCheckedFromList(notCheckedList);
            String[] hiddenArr = new String[hiddenList.size()];
            hiddenList.toArray(hiddenArr);
            viewer.setHiddenTypes(hiddenArr);
        }
    }

    public static String getTextValue(Node node) {
        Node first = node.getFirstChild();
        if (first != null) {
            Text text = (Text)node.getFirstChild();
            return text.getNodeValue().trim();
        }
        return null;
    }

    public static Node getFirstChildByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        for (int c = 0; c < children.getLength(); ++c) {
            Node n = children.item(c);
            if (!n.getNodeName().equals(name)) continue;
            return n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadJDBCProperties() throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/org/apache/ctakes/ytex/ytex.properties");
            this.jdbcProperties = new Properties();
            this.jdbcProperties.load(is);
            if (!this.jdbcProperties.containsKey("db.url") || !this.jdbcProperties.containsKey("db.driver")) {
                this.jdbcProperties = null;
                throw new IOException("Error: required jdbc properties (db.url / db.driver) not specified");
            }
            Properties properties = this.jdbcProperties;
            return properties;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CAS loadDocumentCas(String documentID, TypeSystem typeSystem) throws SQLException, IOException, SAXException, ResourceInitializationException, ClassNotFoundException {
        CAS cas;
        block24: {
            Connection conn = null;
            Statement ps = null;
            ResultSet rs = null;
            GZIPInputStream gzIS = null;
            Properties jdbcProperties = this.loadJDBCProperties();
            cas = CasCreationUtils.createCas((Collection)Collections.EMPTY_LIST, (TypeSystem)typeSystem, (Properties)UIMAFramework.getDefaultPerformanceTuningProperties());
            try {
                Class.forName(jdbcProperties.getProperty("db.driver"));
                conn = DriverManager.getConnection(jdbcProperties.getProperty("db.url"), jdbcProperties.containsKey("db.username") ? jdbcProperties.getProperty("db.username") : null, jdbcProperties.containsKey("db.password") ? jdbcProperties.getProperty("db.password") : null);
                String strSQL = jdbcProperties.containsKey("db.schema") ? "select cas from " + jdbcProperties.getProperty("db.schema") + ".document where document_id = ?" : "select cas from document where document_id = ?";
                ps = conn.prepareStatement(strSQL);
                ps.setInt(1, Integer.parseInt(documentID));
                rs = ps.executeQuery();
                if (rs.next()) {
                    gzIS = new GZIPInputStream(new BufferedInputStream(rs.getBinaryStream(1)));
                    XmlCasDeserializer.deserialize((InputStream)gzIS, (CAS)cas, (boolean)true);
                    break block24;
                }
                throw new RuntimeException("No document with id = " + documentID);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (gzIS != null) {
                        gzIS.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return cas;
    }

    private File createTempDir() {
        File temp = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        temp.mkdir();
        return temp;
    }
}

