/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.eval;

import com.google.common.collect.HashMultiset;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.cr.XReader;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class PrintRelationStatistics {
    public static final String GOLD_VIEW_NAME = "GoldView";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        CollectionReader reader = CollectionReaderFactory.createReader(XReader.class, (Object[])new Object[]{"rootFile", options.trainDirectory.getPath()});
        HashMultiset mentionsBetweenCounts = HashMultiset.create();
        JCas jCas = JCasFactory.createJCasFromPath((String[])new String[]{"../ctakes-type-system/desc/common_type_system.xml"});
        while (reader.hasNext()) {
            reader.getNext(jCas.getCas());
            JCas goldView = jCas.getView(GOLD_VIEW_NAME);
            for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                int mentionsBetween = arg1.getBegin() < arg2.getBegin() ? JCasUtil.selectCovered((JCas)goldView, EntityMention.class, (int)arg1.getEnd(), (int)arg2.getBegin()).size() : -JCasUtil.selectCovered((JCas)goldView, EntityMention.class, (int)arg2.getEnd(), (int)arg1.getBegin()).size();
                mentionsBetweenCounts.add((Object)mentionsBetween);
            }
        }
        ArrayList mentionsBetweenKeys = new ArrayList(mentionsBetweenCounts.elementSet());
        Collections.sort(mentionsBetweenKeys);
        for (Integer mentionsBetween : mentionsBetweenKeys) {
            System.err.printf("%d x%d\n", mentionsBetween, mentionsBetweenCounts.count((Object)mentionsBetween));
        }
    }

    public static class Options {
        @Option(name="--train-dir", usage="specify the directory contraining the XMI training files (for example, /NLP/Corpus/Relations/mipacq/xmi/train)", required=true)
        public File trainDirectory;
    }
}

