/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.data;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.DegreeOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.LocationOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Gold Stats Calculator", description="Count various stats such as token and relation counts based on the gold standard data.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.GENERIC_RELATION, PipeBitInfo.TypeProduct.LOCATION_RELATION, PipeBitInfo.TypeProduct.DEGREE_RELATION})
public class GoldAnnotationStatsCalculator
extends JCasAnnotator_ImplBase {
    public static final String goldViewName = "GoldView";
    public static final String systemViewName = "_InitialView";
    public static final String targetRelationType = "location_of";
    public int tokenCount;
    public int sentenceCount;
    public int entityMentionCount;
    public int entityMentionPairCount;
    public int relationArgumentDistance;
    public Multiset<String> relationTypes;
    public Multiset<String> entityMentionPairTypes;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.tokenCount = 0;
        this.sentenceCount = 0;
        this.entityMentionCount = 0;
        this.entityMentionPairCount = 0;
        this.relationArgumentDistance = 0;
        this.relationTypes = HashMultiset.create();
        this.entityMentionPairTypes = HashMultiset.create();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        System.out.println();
        System.out.format("%-30s%d\n", "token count", this.tokenCount);
        System.out.format("%-30s%d\n", "sentence count", this.sentenceCount);
        System.out.format("%-30s%d\n", "entity mention count", this.entityMentionCount);
        System.out.format("%-30s%d\n", "entity mention pair count", this.entityMentionPairCount);
        System.out.format("%-30s%d\n", "location_of count", this.relationTypes.count((Object)targetRelationType));
        System.out.format("%-30s%d\n", "degree_of count", this.relationTypes.count((Object)"degree_of"));
        System.out.println();
        System.out.format("%-40s%f\n", "average distance between arguments", Float.valueOf((float)this.relationArgumentDistance / (float)this.relationTypes.count((Object)targetRelationType)));
        System.out.println();
        System.out.println("location_of:");
        System.out.format("%-40s%d\n", "anatomical site - disease/disorder", this.entityMentionPairTypes.count((Object)"anatomical site - disease/disorder"));
        System.out.format("%-40s%d\n", "anatomical site - sign/symptom", this.entityMentionPairTypes.count((Object)"anatomical site - sign/symptom"));
        System.out.format("%-40s%d\n", "anatomical site - procedure", this.entityMentionPairTypes.count((Object)"anatomical site - procedure"));
        System.out.println();
        System.out.println("degree_of:");
        System.out.format("%-40s%d\n", "disorder - modifier", this.entityMentionPairTypes.count((Object)"disease/disorder - modifier"));
        System.out.format("%-40s%d\n", "sign/symptom - modifier", this.entityMentionPairTypes.count((Object)"sign/symptom - modifier"));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        JCas goldView;
        try {
            goldView = jCas.getView(goldViewName);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        try {
            systemView = jCas.getView(systemViewName);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        this.countTokens(jCas);
        this.countSentences(jCas);
        this.countEntities(goldView);
        this.countEntityMentionPairs(jCas, goldView);
        this.countDistanceBetweenArguments(systemView, goldView);
        this.countEntityMentionPairTypes(jCas, goldView);
        this.countRelationTypes(goldView);
    }

    private void countTokens(JCas jCas) {
        Collection baseTokens = JCasUtil.select((JCas)jCas, BaseToken.class);
        this.tokenCount += baseTokens.size();
    }

    private void countSentences(JCas jCas) {
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        this.sentenceCount += sentences.size();
    }

    private void countEntityMentionPairs(JCas jCas, JCas goldView) {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            Iterable pairs;
            if (targetRelationType.equals(targetRelationType)) {
                LocationOfRelationExtractorAnnotator emPairAnnot = new LocationOfRelationExtractorAnnotator();
                pairs = emPairAnnot.getCandidateRelationArgumentPairs(goldView, (Annotation)sentence);
                this.entityMentionPairCount += pairs.size();
            }
            if (!targetRelationType.equals("degree_of")) continue;
            DegreeOfRelationExtractorAnnotator degreeOfAnnot = new DegreeOfRelationExtractorAnnotator();
            pairs = degreeOfAnnot.getCandidateRelationArgumentPairs(goldView, (Annotation)sentence);
            this.entityMentionPairCount += pairs.size();
        }
    }

    private void countEntityMentionPairTypes(JCas jCas, JCas goldView) {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            String type1;
            Iterable pairs;
            if (targetRelationType.equals(targetRelationType)) {
                LocationOfRelationExtractorAnnotator emPairAnnot = new LocationOfRelationExtractorAnnotator();
                pairs = emPairAnnot.getCandidateRelationArgumentPairs(goldView, (Annotation)sentence);
                for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
                    type1 = GoldAnnotationStatsCalculator.getEntityType(pair.getArg1().getTypeID());
                    String type2 = GoldAnnotationStatsCalculator.getEntityType(pair.getArg2().getTypeID());
                    this.entityMentionPairTypes.add((Object)(type1 + " - " + type2));
                }
            }
            if (!targetRelationType.equals("degree_of")) continue;
            DegreeOfRelationExtractorAnnotator degreeOfAnnot = new DegreeOfRelationExtractorAnnotator();
            pairs = degreeOfAnnot.getCandidateRelationArgumentPairs(goldView, (Annotation)sentence);
            for (RelationExtractorAnnotator.IdentifiedAnnotationPair pair : pairs) {
                type1 = GoldAnnotationStatsCalculator.getEntityType(pair.getArg1().getTypeID());
                this.entityMentionPairTypes.add((Object)(type1 + " - " + "modifier"));
            }
        }
    }

    private void countRelationTypes(JCas jCas) {
        for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
            String category = binaryTextRelation.getCategory();
            this.relationTypes.add((Object)category);
        }
    }

    private void countDistanceBetweenArguments(JCas systemView, JCas goldView) {
        for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
            if (!binaryTextRelation.getCategory().equals(targetRelationType)) continue;
            IdentifiedAnnotation arg1 = (IdentifiedAnnotation)binaryTextRelation.getArg1().getArgument();
            IdentifiedAnnotation arg2 = (IdentifiedAnnotation)binaryTextRelation.getArg2().getArgument();
            this.relationArgumentDistance += GoldAnnotationStatsCalculator.getTokenDistance(systemView, arg1, arg2);
        }
    }

    private void countEntities(JCas jCas) {
        Collection entityMentions = JCasUtil.select((JCas)jCas, EntityMention.class);
        this.entityMentionCount += entityMentions.size();
    }

    public static int getTokenDistance(JCas systemView, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        List baseTokens = JCasUtil.selectBetween((JCas)systemView, BaseToken.class, (AnnotationFS)arg1, (AnnotationFS)arg2);
        return baseTokens.size();
    }

    private static String getEntityType(int typeId) {
        if (typeId == 0) {
            return "unknown";
        }
        if (typeId == 1) {
            return "drug";
        }
        if (typeId == 2) {
            return "disease/disorder";
        }
        if (typeId == 3) {
            return "sign/symptom";
        }
        if (typeId == 4) {
            return "none";
        }
        if (typeId == 5) {
            return "procedure";
        }
        if (typeId == 6) {
            return "anatomical site";
        }
        return "n/a";
    }
}

