/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class PrepositionFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        HashSet<String> prepositions = new HashSet<String>(Arrays.asList("about", "above", "across", "against", "amid", "around", "at", "atop", "behind", "below", "beneath", "beside", "between", "beyond", "by", "for", "from", "down", "in", "including", "inside", "into", "mid", "near", "of", "off", "on", "onto", "opposite", "out", "outside", "over", "round", "through", "throughout", "to", "under", "underneath", "with", "within", "without"));
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (arg1.getEnd() < arg2.getBegin()) {
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (int)arg1.getEnd(), (int)arg2.getBegin())) {
                if (!prepositions.contains(token.getCoveredText())) continue;
                features.add(new Feature("arg1_preposition_arg2", (Object)token.getCoveredText()));
            }
        }
        if (arg2.getEnd() < arg1.getBegin()) {
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (int)arg2.getEnd(), (int)arg1.getBegin())) {
                if (!prepositions.contains(token.getCoveredText())) continue;
                features.add(new Feature("arg2_preposition_arg1", (Object)token.getCoveredText()));
            }
        }
        return features;
    }
}

