/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.multi;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.ClassifierFactory;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.DataWriterFactory;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;

public abstract class CleartkMultiAnnotator<OUTCOME_TYPE>
extends JCasAnnotator_ImplBase
implements Initializable {
    public static final String PARAM_CLASSIFIER_FACTORY_CLASS_NAME = "classifierFactoryClassName";
    private static final String DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME = "org.cleartk.ml.jar.JarClassifierFactory";
    @ConfigurationParameter(name="classifierFactoryClassName", mandatory=false, description="provides the full name of the ClassifierFactory class to be used.", defaultValue={"org.cleartk.ml.jar.JarClassifierFactory"})
    private String classifierFactoryClassName;
    public static final String PARAM_DATA_WRITER_FACTORY_CLASS_NAME = "dataWriterFactoryClassName";
    private static final String DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME = "org.cleartk.ml.jar.DefaultDataWriterFactory";
    @ConfigurationParameter(name="dataWriterFactoryClassName", mandatory=false, description="provides the full name of the DataWriterFactory class to be used.", defaultValue={"org.cleartk.ml.jar.DefaultDataWriterFactory"})
    private String dataWriterFactoryClassName;
    public static final String PARAM_IS_TRAINING = "isTraining";
    @ConfigurationParameter(name="isTraining", mandatory=false, description="determines whether this annotator is writing training data or using a classifier to annotate. Normally inferred automatically based on whether or not a DataWriterFactory class has been set.")
    private Boolean isTraining;
    private boolean primitiveIsTraining;
    protected ClassifierFactory<?> classifierFactory;
    protected DataWriterFactory<?> dataWriterFactory;
    protected Map<String, Classifier<OUTCOME_TYPE>> classifiers;
    protected Map<String, DataWriter<OUTCOME_TYPE>> dataWriters;
    private UimaContext uimaContext;
    protected File outputDirectoryRoot;
    protected File classifierJarPathRoot;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this.dataWriterFactoryClassName == null && this.classifierFactoryClassName == null) {
            CleartkInitializationException.neitherParameterSet((String)PARAM_DATA_WRITER_FACTORY_CLASS_NAME, (Object)this.dataWriterFactoryClassName, (String)PARAM_CLASSIFIER_FACTORY_CLASS_NAME, (Object)this.classifierFactoryClassName);
        }
        if (this.isTraining != null) {
            this.primitiveIsTraining = this.isTraining;
        } else if (!DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME.equals(this.dataWriterFactoryClassName)) {
            this.primitiveIsTraining = true;
        } else if (context.getConfigParameterValue("outputDirectory") != null) {
            this.primitiveIsTraining = true;
        } else if (!DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME.equals(this.classifierFactoryClassName)) {
            this.primitiveIsTraining = false;
        } else if (context.getConfigParameterValue("classifierJarPath") != null) {
            this.primitiveIsTraining = false;
        } else {
            String message = "Please specify PARAM_IS_TRAINING - unable to infer it from context";
            throw new IllegalArgumentException(message);
        }
        this.uimaContext = context;
        UimaContextAdmin contextAdmin = (UimaContextAdmin)this.uimaContext;
        ConfigurationManager manager = contextAdmin.getConfigurationManager();
        if (this.isTraining()) {
            this.dataWriters = new HashMap<String, DataWriter<OUTCOME_TYPE>>();
            this.outputDirectoryRoot = (File)manager.getConfigParameterValue("outputDirectory");
            this.dataWriterFactory = (DataWriterFactory)InitializableFactory.create((UimaContext)context, (String)this.dataWriterFactoryClassName, DataWriterFactory.class);
        } else {
            this.classifiers = new HashMap<String, Classifier<OUTCOME_TYPE>>();
            this.classifierJarPathRoot = (File)manager.getConfigParameterValue("classifierJarPath");
            this.classifierFactory = (ClassifierFactory)InitializableFactory.create((UimaContext)context, (String)this.classifierFactoryClassName, ClassifierFactory.class);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.isTraining()) {
            try {
                for (DataWriter<OUTCOME_TYPE> dataWriter : this.dataWriters.values()) {
                    dataWriter.finish();
                }
            }
            catch (CleartkProcessingException ctke) {
                throw new AnalysisEngineProcessException((Throwable)((Object)ctke));
            }
        }
    }

    protected boolean isTraining() {
        return this.primitiveIsTraining;
    }

    protected Classifier<OUTCOME_TYPE> getClassifier(String name) throws ResourceInitializationException {
        Classifier untypedClassifier;
        if (this.classifiers.containsKey(name)) {
            return this.classifiers.get(name);
        }
        File classifierJarPath = new File(this.classifierJarPathRoot, name);
        UimaContextAdmin contextAdmin = (UimaContextAdmin)this.uimaContext;
        ConfigurationManager manager = contextAdmin.getConfigurationManager();
        manager.setConfigParameterValue(contextAdmin.getQualifiedContextName() + "classifierJarPath", (Object)classifierJarPath.getPath());
        ClassifierFactory factory = (ClassifierFactory)InitializableFactory.create((UimaContext)this.uimaContext, (String)this.classifierFactoryClassName, ClassifierFactory.class);
        try {
            untypedClassifier = factory.createClassifier();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        Classifier classifier = (Classifier)ReflectionUtil.uncheckedCast(untypedClassifier);
        ReflectionUtil.checkTypeParameterIsAssignable(CleartkMultiAnnotator.class, (String)"OUTCOME_TYPE", (Object)((Object)this), Classifier.class, (String)"OUTCOME_TYPE", (Object)classifier);
        InitializableFactory.initialize(untypedClassifier, (UimaContext)this.getContext());
        this.classifiers.put(name, classifier);
        return classifier;
    }

    protected DataWriter<OUTCOME_TYPE> getDataWriter(String name) throws ResourceInitializationException {
        DataWriter<?> untypedDataWriter;
        if (this.dataWriters.containsKey(name)) {
            return this.dataWriters.get(name);
        }
        File dataWriterPath = new File(this.outputDirectoryRoot, name);
        UimaContextAdmin contextAdmin = (UimaContextAdmin)this.uimaContext;
        ConfigurationManager manager = contextAdmin.getConfigurationManager();
        manager.setConfigParameterValue(contextAdmin.getQualifiedContextName() + "outputDirectory", (Object)dataWriterPath);
        try {
            untypedDataWriter = this.dataWriterFactory.createDataWriter();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        InitializableFactory.initialize(untypedDataWriter, (UimaContext)this.uimaContext);
        DataWriter dataWriter = (DataWriter)ReflectionUtil.uncheckedCast(untypedDataWriter);
        this.dataWriters.put(name, dataWriter);
        return dataWriter;
    }
}

