/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.AnaphoricityAttributeCalculator;
import org.apache.ctakes.coreference.util.FeatureVector;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.coreference.util.SyntaxAttributeCalculator;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.utils.tree.FragmentUtils;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.ctakes.utils.wiki.WikiIndex;
import org.apache.uima.jcas.JCas;

public class SvmVectorCreator {
    HashSet<String> stopwords = null;
    private svm_model anaph_model = null;
    ArrayList<SimpleTree> frags = new ArrayList();
    WikiIndex wiki = null;
    static final int NUM_WIKI_HITS = 5;

    public SvmVectorCreator(HashSet<String> stopwords) {
        this.stopwords = stopwords;
        try {
            this.wiki = new WikiIndex(5, FileLocator.locateFile((String)"org/apache/ctakes/coreference/models/index_med_5k").getAbsolutePath(), "text");
            this.wiki.initialize();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.wiki = null;
        }
    }

    public svm_node[] createAnaphoricityVector(Markable m, JCas aJCas) {
        String[] feats = FeatureVector.getAnaphoricityFeatures();
        ArrayList<svm_node> nodeList = new ArrayList<svm_node>();
        AnaphoricityAttributeCalculator aac = new AnaphoricityAttributeCalculator(aJCas, m);
        aac.setStopWordsList(this.stopwords);
        for (int i = 0; i < feats.length; ++i) {
            try {
                int ii;
                Object val = aac.getClass().getMethod("calcm" + feats[i], new Class[0]).invoke((Object)aac, new Object[0]);
                if (!(val instanceof String)) continue;
                String s = (String)val;
                if (s.equals("yes") || s.equals("Y") || s.equals("C") || s.equals("P")) {
                    svm_node node = new svm_node();
                    node.index = i + 1;
                    node.value = 1.0;
                    nodeList.add(node);
                    continue;
                }
                if (s.equals("S")) {
                    svm_node node = new svm_node();
                    node.index = i + 1;
                    node.value = 0.5;
                    nodeList.add(node);
                    continue;
                }
                if (s.equals("U") || s.equals("N") || s.equals("no") || s.equals("I") || (ii = Integer.parseInt(s)) < 0 || ii > 6) continue;
                svm_node node = new svm_node();
                node.index = i + 1;
                node.value = (double)ii / 6.0;
                nodeList.add(node);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nodeList.toArray(new svm_node[0]);
    }

    private double calcAnaphoricity(JCas aJCas, Markable m) {
        svm_node[] nodes = this.createAnaphoricityVector(m, aJCas);
        double[] prob = new double[2];
        svm.svm_predict_probability((svm_model)this.anaph_model, (svm_node[])nodes, (double[])prob);
        int[] labels = new int[2];
        svm.svm_get_labels((svm_model)this.anaph_model, (int[])labels);
        int anaph_idx = labels[0] == 1 ? 0 : 1;
        return prob[anaph_idx];
    }

    public svm_node[] getNodeFeatures(Markable anaphor, Markable antecedent, JCas aJCas) {
        return this.getNodeFeatures(anaphor, antecedent, aJCas, false);
    }

    public svm_node[] getNodeFeatures(Markable anaphor, Markable antecedent, JCas aJCas, boolean needsAnaph) {
        svm_node n;
        LinkedList<svm_node> nodes = new LinkedList<svm_node>();
        String[] feats = FeatureVector.getNECorefFeatures();
        SyntaxAttributeCalculator sac = new SyntaxAttributeCalculator(aJCas, antecedent, anaphor, this.wiki);
        sac.setStopWordsList(this.stopwords);
        int ind = 0;
        int i = 0;
        while (i < feats.length) {
            try {
                if (feats[i].equals("Anaph")) {
                    double anaph_prob = needsAnaph ? this.calcAnaphoricity(aJCas, anaphor) : 1.0;
                    n = new svm_node();
                    n.index = ind + 1;
                    n.value = anaph_prob;
                    nodes.add(n);
                } else if (feats[i].contains(":")) {
                    String[] catFeat = feats[i].split(":");
                    String featType = catFeat[0];
                    String featName = catFeat[1];
                    String methodName = "num" + featName;
                    int num = (Integer)sac.getClass().getMethod(methodName, Markable.class).invoke((Object)sac, new Object[]{anaphor});
                    methodName = "calc" + featType + featName;
                    Method method = sac.getClass().getMethod(methodName, Integer.class, Markable.class);
                    int j = 0;
                    while (j < num) {
                        String val = (String)method.invoke((Object)sac, new Object[]{j, anaphor});
                        if (val.equalsIgnoreCase("Y")) {
                            svm_node n2 = new svm_node();
                            n2.index = ind + 1;
                            n2.value = 1.0;
                            nodes.add(n2);
                        }
                        ++j;
                        ++ind;
                    }
                } else {
                    svm_node n3;
                    Object val = sac.getClass().getMethod("calc" + feats[i], new Class[0]).invoke((Object)sac, new Object[0]);
                    if (val instanceof String) {
                        String s = (String)val;
                        if (s.equals("yes") || s.equals("Y") || s.equals("C")) {
                            n = new svm_node();
                            n.index = ind + 1;
                            n.value = 1.0;
                            nodes.add(n);
                        }
                    } else if (val instanceof Integer) {
                        int v = (Integer)val;
                        if (v != 0) {
                            n = new svm_node();
                            n.index = ind + 1;
                            n.value = v;
                            nodes.add(n);
                        }
                    } else if (val instanceof Double) {
                        if ((Double)val != 0.0) {
                            n3 = new svm_node();
                            n3.index = ind + 1;
                            n3.value = (Double)val;
                            nodes.add(n3);
                        }
                    } else if (val instanceof Boolean && ((Boolean)val).booleanValue()) {
                        n3 = new svm_node();
                        n3.index = ind + 1;
                        n3.value = 1.0;
                        nodes.add(n3);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
            ++ind;
        }
        if (this.frags != null && this.frags.size() > 0) {
            SimpleTree tn = TreeExtractor.extractPathTree((TreebankNode)MarkableTreeUtils.markableNode(aJCas, antecedent.getBegin(), antecedent.getEnd()), (TreebankNode)MarkableTreeUtils.markableNode(aJCas, anaphor.getBegin(), anaphor.getEnd()));
            for (SimpleTree frag : this.frags) {
                if (TreeUtils.contains((SimpleTree)tn, (SimpleTree)frag)) {
                    n = new svm_node();
                    n.index = ind + 1;
                    n.value = 1.0;
                    nodes.add(n);
                }
                ++ind;
            }
        }
        return nodes.toArray(new svm_node[0]);
    }

    public void setFrags(Collection<String> treeFrags) {
        for (String frag : treeFrags) {
            this.frags.add(FragmentUtils.frag2tree((String)frag));
        }
    }
}

