/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.io.File;
import java.io.IOException;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;

public class AbstractClassifier {
    private svm_model svmCls = null;
    private int clsIndex = -1;

    public AbstractClassifier(File fn, int len) {
        try {
            this.svmCls = svm.svm_load_model((String)fn.getAbsolutePath());
            int[] labels = new int[2];
            svm.svm_get_labels((svm_model)this.svmCls, (int[])labels);
            this.clsIndex = labels[0] == 1 ? 0 : 1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double predict(svm_node[] vec) {
        return this.predict(vec, null);
    }

    public double predict(svm_node[] vec, TreebankNode path) {
        double[] probs = new double[2];
        svm.svm_predict_probability((svm_model)this.svmCls, (svm_node[])vec, (double[])probs);
        return probs[this.clsIndex];
    }
}

