/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.coreference.extractors.ContinuousTextExtractor;
import org.apache.ctakes.relationextractor.ae.features.DependencyTreeFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

public class MentionClusterMentionFeaturesExtractor
implements FeatureExtractor1<Markable> {
    private FeatureExtractor1<BaseToken> coveredText = new CoveredTextExtractor();
    private FeatureExtractor1<Markable> tokenIdentityContext = new CleartkExtractor(BaseToken.class, this.coveredText, new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()}), new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)});
    private FeatureExtractor1<BaseToken> continuousText = null;
    private FeatureExtractor1<Markable> tokenVectorContext = null;
    private FeatureExtractor1<BaseToken> pos = new TypePathExtractor(BaseToken.class, "partOfSpeech");
    private FeatureExtractor1<Markable> tokenPOS = new CleartkExtractor(BaseToken.class, this.pos, new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})});
    private FeatureExtractor1<Markable> mentionFeaturesExtractor = new NamingExtractor1("mention1pos", this.tokenPOS);

    public MentionClusterMentionFeaturesExtractor() throws CleartkExtractorException {
        this(null);
    }

    public MentionClusterMentionFeaturesExtractor(String vectorFile) throws CleartkExtractorException {
        if (vectorFile != null) {
            this.continuousText = new ContinuousTextExtractor(vectorFile);
            this.tokenVectorContext = new CleartkExtractor(BaseToken.class, this.continuousText, new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Preceding(1), new CleartkExtractor.Following(1)});
        }
    }

    public List<Feature> extract(JCas view, Markable focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        feats.addAll(this.tokenIdentityContext.extract(view, (Annotation)focusAnnotation));
        feats.addAll(this.mentionFeaturesExtractor.extract(view, (Annotation)focusAnnotation));
        feats.add(new Feature("NumCoveredTokens", (Object)JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)focusAnnotation).size()));
        feats.addAll(DependencyTreeFeaturesExtractor.extractForNode((JCas)view, (IdentifiedAnnotation)focusAnnotation, (String)"dep"));
        return feats;
    }
}

