/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.fsm.machines.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.IntegerCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;
import org.apache.ctakes.drugner.fsm.elements.conditions.StrengthCondition;
import org.apache.ctakes.drugner.fsm.output.util.SuffixStrengthToken;

public class SuffixStrengthFSM {
    Set iv_textSuffixSet = new HashSet();
    private Set iv_machineSet = new HashSet();

    public SuffixStrengthFSM() {
        this.iv_textSuffixSet.add("gtts");
        this.iv_textSuffixSet.add("ui");
        this.iv_textSuffixSet.add("iu");
        this.iv_textSuffixSet.add("meq");
        this.iv_textSuffixSet.add("mcg");
        this.iv_textSuffixSet.add("gr");
        this.iv_textSuffixSet.add("tsp");
        this.iv_textSuffixSet.add("tbsp");
        this.iv_textSuffixSet.add("g");
        this.iv_textSuffixSet.add("mg");
        this.iv_textSuffixSet.add("dl");
        this.iv_textSuffixSet.add("cl");
        this.iv_textSuffixSet.add("ml");
        this.iv_textSuffixSet.add("kg");
        this.iv_textSuffixSet.add("cc");
        this.iv_textSuffixSet.add("ou");
        this.iv_machineSet.add(this.getDashMachine());
    }

    private Machine getDashMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState leftNumTextState = new NamedState("LEFT_DOSAGE");
        NamedState rightNumTextState = new NamedState("RIGHT_DOSAGE");
        NamedState fslashState = new NamedState("FSLASH");
        PunctuationValueCondition dashCondition = new PunctuationValueCondition('/');
        StrengthCondition leftNumTextCondition = new StrengthCondition();
        IntegerCondition rightIntegerCondition = new IntegerCondition();
        WordSetCondition rightNumTextCondition = new WordSetCondition(this.iv_textSuffixSet, false);
        startState.addTransition((Condition)leftNumTextCondition, (State)leftNumTextState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        leftNumTextState.addTransition((Condition)dashCondition, (State)fslashState);
        leftNumTextState.addTransition((Condition)new AnyCondition(), (State)startState);
        fslashState.addTransition((Condition)rightNumTextCondition, (State)endState);
        fslashState.addTransition((Condition)rightIntegerCondition, (State)rightNumTextState);
        fslashState.addTransition((Condition)new AnyCondition(), (State)startState);
        rightNumTextState.addTransition((Condition)rightNumTextCondition, (State)endState);
        rightNumTextState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public Set execute(List tokens, Set overrideSet) throws Exception {
        HashSet<SuffixStrengthToken> rangeSet = new HashSet<SuffixStrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = (BaseToken)overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            Integer key = new Integer(token.getStartOffset());
            if (overrideOn) {
                if (token.getStartOffset() < overrideEndOffset) continue;
                overrideOn = false;
                overrideEndOffset = -1;
            } else if (overrideTokenMap.containsKey(key)) {
                token = (BaseToken)overrideTokenMap.get(key);
                overrideOn = true;
                overrideEndOffset = token.getEndOffset();
            }
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                SuffixStrengthToken segmentToken = new SuffixStrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                rangeSet.add(segmentToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return rangeSet;
    }
}

