/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.concept.ConceptFactory;
import org.apache.ctakes.dictionary.lookup2.concept.DefaultConcept;
import org.apache.ctakes.dictionary.lookup2.consumer.TermConsumer;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.term.RareWordTerm;
import org.apache.ctakes.dictionary.lookup2.util.CuiCodeUtil;
import org.apache.ctakes.dictionary.lookup2.util.DictionarySpec;
import org.apache.ctakes.dictionary.lookup2.util.FastLookupToken;

@Immutable
public final class DefaultDictionarySpec
implements DictionarySpec {
    private static final RareWordDictionary EMPTY_DICTIONARY = new RareWordDictionary(){

        @Override
        public String getName() {
            return "Empty Dictionary";
        }

        @Override
        public Collection<RareWordTerm> getRareWordHits(FastLookupToken fastLookupToken) {
            return Collections.emptySet();
        }

        @Override
        public Collection<RareWordTerm> getRareWordHits(String rareWordText) {
            return Collections.emptySet();
        }
    };
    private static final ConceptFactory EMPTY_CONCEPT_FACTORY = new ConceptFactory(){

        @Override
        public String getName() {
            return "Empty Concept Factory";
        }

        @Override
        public Concept createConcept(Long cuiCode) {
            return new DefaultConcept(CuiCodeUtil.getInstance().getAsCui(cuiCode));
        }

        @Override
        public Map<Long, Concept> createConcepts(Collection<Long> cuiCodes) {
            return Collections.emptyMap();
        }
    };
    private final Collection<String> _pairNames;
    private final Map<String, String> _pairDictionaryNames;
    private final Map<String, String> _pairConceptFactoryNames;
    private final Map<String, RareWordDictionary> _dictionaries;
    private final Map<String, ConceptFactory> _conceptFactories;
    private final TermConsumer _termConsumer;

    public DefaultDictionarySpec(Map<String, String> pairDictionaryNames, Map<String, String> pairConceptFactoryNames, Map<String, RareWordDictionary> dictionaries, Map<String, ConceptFactory> conceptFactories, TermConsumer termConsumer) {
        this._pairNames = new HashSet<String>(pairDictionaryNames.keySet());
        this._pairNames.addAll(pairConceptFactoryNames.keySet());
        this._pairDictionaryNames = Collections.unmodifiableMap(pairDictionaryNames);
        this._pairConceptFactoryNames = Collections.unmodifiableMap(pairConceptFactoryNames);
        this._dictionaries = Collections.unmodifiableMap(dictionaries);
        this._conceptFactories = Collections.unmodifiableMap(conceptFactories);
        this._termConsumer = termConsumer;
    }

    @Override
    public Collection<String> getPairNames() {
        return this._pairNames;
    }

    @Override
    public RareWordDictionary getDictionary(String pairName) {
        RareWordDictionary dictionary;
        String dictionaryName = this._pairDictionaryNames.get(pairName);
        if (dictionaryName != null && (dictionary = this._dictionaries.get(dictionaryName)) != null) {
            return dictionary;
        }
        return EMPTY_DICTIONARY;
    }

    @Override
    public ConceptFactory getConceptFactory(String pairName) {
        ConceptFactory conceptFactory;
        String conceptFactoryName = this._pairConceptFactoryNames.get(pairName);
        if (conceptFactoryName != null && (conceptFactory = this._conceptFactories.get(conceptFactoryName)) != null) {
            return conceptFactory;
        }
        return EMPTY_CONCEPT_FACTORY;
    }

    @Override
    public Collection<RareWordDictionary> getPairedDictionaries(String conceptFactoryName) {
        HashSet<RareWordDictionary> dictionaries = new HashSet<RareWordDictionary>();
        for (Map.Entry<String, String> pairConceptFactoryName : this._pairConceptFactoryNames.entrySet()) {
            if (!pairConceptFactoryName.getValue().equals(conceptFactoryName)) continue;
            dictionaries.add(this.getDictionary(pairConceptFactoryName.getKey()));
        }
        return dictionaries;
    }

    @Override
    public Collection<ConceptFactory> getPairedConceptFactories(String dictionaryName) {
        HashSet<ConceptFactory> conceptFactories = new HashSet<ConceptFactory>();
        for (Map.Entry<String, String> pairDictionaryName : this._pairDictionaryNames.entrySet()) {
            if (!pairDictionaryName.getValue().equals(dictionaryName)) continue;
            conceptFactories.add(this.getConceptFactory(pairDictionaryName.getKey()));
        }
        return conceptFactories;
    }

    @Override
    public Collection<RareWordDictionary> getDictionaries() {
        return new HashSet<RareWordDictionary>(this._dictionaries.values());
    }

    @Override
    public Collection<ConceptFactory> getConceptFactories() {
        return new HashSet<ConceptFactory>(this._conceptFactories.values());
    }

    @Override
    public TermConsumer getConsumer() {
        return this._termConsumer;
    }
}

