/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.consumer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.consumer.TermConsumer;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;

public abstract class AbstractTermConsumer
implements TermConsumer {
    private static final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private final String _codingScheme;

    public AbstractTermConsumer(UimaContext uimaContext, Properties properties) {
        this._codingScheme = properties.getProperty(CODING_SCHEME_PRP_KEY);
    }

    @Override
    public void consumeHits(JCas jcas, RareWordDictionary dictionary, CollectionMap<TextSpan, Long, ? extends Collection<Long>> textSpanCuis, CollectionMap<Long, Concept, ? extends Collection<Concept>> cuiConcepts) throws AnalysisEngineProcessException {
        String codingScheme = this.getCodingScheme();
        Collection<Integer> usedcTakesSemantics = AbstractTermConsumer.getUsedcTakesSemantics(cuiConcepts);
        HashSetMap semanticCuis = new HashSetMap();
        for (Integer cTakesSemantic : usedcTakesSemantics) {
            semanticCuis.clear();
            for (Map.Entry spanCuis : textSpanCuis) {
                for (Long cuiCode : (Collection)spanCuis.getValue()) {
                    Collection concepts = cuiConcepts.getCollection((Object)cuiCode);
                    if (!AbstractTermConsumer.hascTakesSemantic(cTakesSemantic, concepts)) continue;
                    semanticCuis.placeValue(spanCuis.getKey(), (Object)cuiCode);
                }
            }
            this.consumeTypeIdHits(jcas, codingScheme, cTakesSemantic, (CollectionMap<TextSpan, Long, ? extends Collection<Long>>)semanticCuis, cuiConcepts);
        }
    }

    protected String getCodingScheme() {
        return this._codingScheme;
    }

    protected static Collection<Integer> getUsedcTakesSemantics(CollectionMap<Long, Concept, ? extends Collection<Concept>> cuiConcepts) {
        HashSet<Integer> usedSemanticTypes = new HashSet<Integer>();
        for (Collection concepts : cuiConcepts.getAllCollections()) {
            for (Concept concept : concepts) {
                usedSemanticTypes.addAll(concept.getCtakesSemantics());
            }
        }
        return usedSemanticTypes;
    }

    protected static boolean hascTakesSemantic(Integer cTakesSemantic, Iterable<Concept> concepts) {
        for (Concept concept : concepts) {
            if (!concept.getCtakesSemantics().contains(cTakesSemantic)) continue;
            return true;
        }
        return false;
    }
}

