/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.concept;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.dictionary.lookup2.concept.AbstractConceptFactory;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.concept.DefaultConcept;
import org.apache.ctakes.dictionary.lookup2.util.CuiCodeUtil;
import org.apache.ctakes.dictionary.lookup2.util.JdbcConnectionFactory;
import org.apache.ctakes.dictionary.lookup2.util.TuiCodeUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public class JdbcConceptFactory
extends AbstractConceptFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"JdbcConceptFactory");
    private static final String TABLE_KEY_SUFFIX = "TABLE";
    private static final String INT_CLASS = "INT";
    private static final String LONG_CLASS = "LONG";
    private static final String TEXT_CLASS = "TEXT";
    private static final String TUI_CLASS = "TUI";
    private static final String PREFTERM_CLASS = "PREFTERM";
    private final Collection<ConceptTableInfo> _conceptTableInfos;

    private static String adjustOldTableName(String tableName) {
        if (tableName.equalsIgnoreCase("SNOMEDTABLE")) {
            return "SNOMEDCTTABLE";
        }
        if (tableName.equalsIgnoreCase("ICD9TABLE")) {
            return "ICD9CMTABLE";
        }
        if (tableName.equalsIgnoreCase("ICD10TABLE")) {
            return "ICD10PCSTABLE";
        }
        return tableName;
    }

    private static String adjustOldTableClass(String typeOrOldName) {
        if (typeOrOldName.equalsIgnoreCase("SNOMEDCT")) {
            return LONG_CLASS;
        }
        if (typeOrOldName.equalsIgnoreCase("RXNORM") || typeOrOldName.equalsIgnoreCase("ICD9CM") || typeOrOldName.equalsIgnoreCase("ICD10PCS")) {
            return TEXT_CLASS;
        }
        return typeOrOldName;
    }

    private static Map<String, String> getConceptTables(Properties properties) {
        Set<String> keys = properties.stringPropertyNames();
        HashMap<String, String> conceptTables = new HashMap<String, String>();
        for (String key : keys) {
            String keyName = key.trim().toUpperCase();
            if (!keyName.endsWith(TABLE_KEY_SUFFIX)) continue;
            conceptTables.put(JdbcConceptFactory.adjustOldTableName(keyName), JdbcConceptFactory.adjustOldTableClass(properties.getProperty(key)));
        }
        return conceptTables;
    }

    public JdbcConceptFactory(String name, UimaContext uimaContext, Properties properties) throws SQLException {
        this(name, properties.getProperty("jdbcDriver"), properties.getProperty("jdbcUrl"), properties.getProperty("jdbcUser"), properties.getProperty("jdbcPass"), JdbcConceptFactory.getConceptTables(properties));
    }

    public JdbcConceptFactory(String name, String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPass, Map<String, String> conceptTables) throws SQLException {
        super(name);
        boolean connected = false;
        try {
            Connection connection = JdbcConnectionFactory.getInstance().getConnection(jdbcDriver, jdbcUrl, jdbcUser, jdbcPass);
            connected = connection != null;
            this._conceptTableInfos = JdbcConceptFactory.createTableInfos(connection, conceptTables);
        }
        catch (SQLException sqlE) {
            if (!connected) {
                LOGGER.error((Object)("Could not Connect to Concept Factory " + name));
            } else {
                LOGGER.error((Object)"Could not create Concept Data Selection Call", (Throwable)sqlE);
            }
            throw sqlE;
        }
    }

    @Override
    public Concept createConcept(Long cuiCode) {
        HashSetMap codes = new HashSetMap();
        String prefTerm = null;
        for (ConceptTableInfo conceptTableInfo : this._conceptTableInfos) {
            switch (conceptTableInfo.__classType) {
                case "TUI": {
                    codes.addAllValues((Object)conceptTableInfo.__conceptName, JdbcConceptFactory.getTuiCodes(conceptTableInfo.__preparedStatement, cuiCode));
                    break;
                }
                case "PREFTERM": {
                    prefTerm = JdbcConceptFactory.getPreferredTerm(conceptTableInfo.__preparedStatement, cuiCode);
                    break;
                }
                case "INT": {
                    codes.addAllValues((Object)conceptTableInfo.__conceptName, JdbcConceptFactory.getIntegerCodes(conceptTableInfo.__preparedStatement, cuiCode));
                    break;
                }
                case "LONG": {
                    codes.addAllValues((Object)conceptTableInfo.__conceptName, JdbcConceptFactory.getLongCodes(conceptTableInfo.__preparedStatement, cuiCode));
                    break;
                }
                case "TEXT": {
                    codes.addAllValues((Object)conceptTableInfo.__conceptName, JdbcConceptFactory.getStringCodes(conceptTableInfo.__preparedStatement, cuiCode));
                }
            }
        }
        return new DefaultConcept(CuiCodeUtil.getInstance().getAsCui(cuiCode), prefTerm, (CollectionMap<String, String, ? extends Collection<String>>)codes);
    }

    private static Collection<String> getTuiCodes(PreparedStatement selectCall, Long cuiCode) {
        HashSet<String> codes = new HashSet<String>();
        try {
            JdbcConceptFactory.fillSelectCall(selectCall, cuiCode);
            ResultSet resultSet = selectCall.executeQuery();
            while (resultSet.next()) {
                codes.add(TuiCodeUtil.getAsTui(resultSet.getInt(2)));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return codes;
    }

    private static String getPreferredTerm(PreparedStatement selectCall, Long cuiCode) {
        String preferredName = "";
        try {
            JdbcConceptFactory.fillSelectCall(selectCall, cuiCode);
            ResultSet resultSet = selectCall.executeQuery();
            if (resultSet.next()) {
                preferredName = resultSet.getString(2);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return preferredName;
    }

    private static Collection<String> getIntegerCodes(PreparedStatement selectCall, Long cuiCode) {
        HashSet<String> codes = new HashSet<String>();
        try {
            JdbcConceptFactory.fillSelectCall(selectCall, cuiCode);
            ResultSet resultSet = selectCall.executeQuery();
            while (resultSet.next()) {
                codes.add(Integer.toString(resultSet.getInt(2)));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return codes;
    }

    private static Collection<String> getLongCodes(PreparedStatement selectCall, Long cuiCode) {
        HashSet<String> codes = new HashSet<String>();
        try {
            JdbcConceptFactory.fillSelectCall(selectCall, cuiCode);
            ResultSet resultSet = selectCall.executeQuery();
            while (resultSet.next()) {
                codes.add(Long.toString(resultSet.getLong(2)));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return codes;
    }

    private static Collection<String> getStringCodes(PreparedStatement selectCall, Long cuiCode) {
        HashSet<String> codes = new HashSet<String>();
        try {
            JdbcConceptFactory.fillSelectCall(selectCall, cuiCode);
            ResultSet resultSet = selectCall.executeQuery();
            while (resultSet.next()) {
                codes.add(resultSet.getString(2));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return codes;
    }

    private static Collection<ConceptTableInfo> createTableInfos(Connection connection, Map<String, String> conceptTables) throws SQLException {
        if (conceptTables == null || conceptTables.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<String> dbTablesNames = JdbcConceptFactory.getDbTableNames(connection);
        ArrayList<ConceptTableInfo> tableInfos = new ArrayList<ConceptTableInfo>();
        for (Map.Entry<String, String> conceptTable : conceptTables.entrySet()) {
            String tableName = conceptTable.getKey().trim().toUpperCase();
            if (!tableName.endsWith(TABLE_KEY_SUFFIX) || tableName.length() < 6) {
                LOGGER.error((Object)("Cannot have a concept table named " + tableName));
                continue;
            }
            if (!dbTablesNames.contains(tableName) && !dbTablesNames.contains(tableName = tableName.substring(0, tableName.length() - 5))) {
                LOGGER.error((Object)("Table " + tableName + TABLE_KEY_SUFFIX + " and/or " + tableName + " not found in Database"));
                continue;
            }
            String tableClass = conceptTable.getValue().trim().toUpperCase();
            if (tableClass.isEmpty() || !tableClass.equals(TUI_CLASS) && !tableClass.equals(PREFTERM_CLASS) && !tableClass.equals(INT_CLASS) && !tableClass.equals(LONG_CLASS) && !tableClass.equals(TEXT_CLASS)) {
                LOGGER.error((Object)("Cannot have a concept table with class " + tableClass));
                continue;
            }
            String conceptName = conceptTable.getKey().trim();
            conceptName = conceptName.substring(0, conceptName.length() - 5);
            String lookupSql = "SELECT * FROM " + tableName + " WHERE CUI = ?";
            PreparedStatement statement = connection.prepareStatement(lookupSql);
            tableInfos.add(new ConceptTableInfo(tableName, conceptName, tableClass, statement));
            LOGGER.info((Object)("Connected to concept table " + tableName + " with class " + tableClass));
        }
        return tableInfos;
    }

    private static Collection<String> getDbTableNames(Connection connection) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        ResultSet resultSet = metadata.getTables(null, null, "%", null);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (resultSet.next()) {
            tableNames.add(resultSet.getString("TABLE_NAME").toUpperCase());
        }
        resultSet.close();
        return tableNames;
    }

    private static void fillSelectCall(PreparedStatement selectCall, Long cuiCode) throws SQLException {
        selectCall.clearParameters();
        selectCall.setLong(1, cuiCode);
    }

    private static class ConceptTableInfo {
        private final String __conceptName;
        private final String __classType;
        private final PreparedStatement __preparedStatement;

        private ConceptTableInfo(String tableName, String conceptName, String classType, PreparedStatement preparedStatement) {
            this.__conceptName = conceptName;
            this.__classType = classType;
            this.__preparedStatement = preparedStatement;
        }
    }
}

