/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.vo;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;

@Immutable
public final class LookupHit {
    private final int iv_startOffset;
    private final int iv_endOffset;
    private final MetaDataHit iv_mdh;
    private final int _hashCode;

    public LookupHit(MetaDataHit mdh, int startOffset, int endOffset) {
        this.iv_mdh = mdh;
        this.iv_startOffset = startOffset;
        this.iv_endOffset = endOffset;
        this._hashCode = mdh.hashCode() * 7 + 1000 * endOffset + startOffset;
    }

    public int getEndOffset() {
        return this.iv_endOffset;
    }

    public MetaDataHit getDictMetaDataHit() {
        return this.iv_mdh;
    }

    public int getStartOffset() {
        return this.iv_startOffset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LookupHit) {
            LookupHit lh = (LookupHit)obj;
            return this.iv_startOffset == lh.getStartOffset() && this.iv_endOffset == lh.getEndOffset() && this.iv_mdh.equals(lh.getDictMetaDataHit());
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String getUniqueKey() {
        StringBuffer key = new StringBuffer();
        key.append("s=");
        key.append(this.iv_startOffset);
        key.append("/");
        key.append("e=");
        key.append(this.iv_endOffset);
        key.append("/");
        ArrayList<String> mfNameList = new ArrayList<String>(this.iv_mdh.getMetaFieldNames());
        Collections.sort(mfNameList);
        for (String mfName : mfNameList) {
            String mfValue = this.iv_mdh.getMetaFieldValue(mfName);
            key.append(mfName);
            key.append("=");
            key.append(mfValue);
            key.append(",");
        }
        return key.toString();
    }
}

